% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus.R
\name{locus}
\alias{locus}
\title{Create locus object for plotting}
\usage{
locus(
  gene = NULL,
  data,
  xrange = NULL,
  seqname = NULL,
  flank = NULL,
  fix_window = NULL,
  ens_db,
  chrom = NULL,
  pos = NULL,
  p = NULL,
  yvar = NULL,
  labs = NULL,
  index_snp = NULL,
  LD = NULL
)
}
\arguments{
\item{gene}{Optional character value specifying which gene to view. Either
\code{gene} or \code{xrange} plus \code{seqname} must be specified.}

\item{data}{Dataset (data.frame or data.table) to use for plot.}

\item{xrange}{Optional vector of genomic position range for the x axis.}

\item{seqname}{Optional, specifies which chromosome to plot.}

\item{flank}{Single value or vector with 2 values for how much flanking
region left and right of the gene to show. Defaults to 50,000.}

\item{fix_window}{Optional alternative to \code{flank}, which allows users to
specify a fixed genomic window centred on the specified gene. Both \code{flank}
and \code{fix_window} cannot be specified simultaneously.}

\item{ens_db}{Either a character string which specifies which Ensembl
database package (version 86 and earlier for Homo sapiens) to query for
gene and exon positions (see \code{ensembldb} Bioconductor package). Or an
\code{ensembldb} object which can be obtained from the AnnotationHub database.
See the vignette and the \code{AnnotationHub} Bioconductor package for how to
create this object.}

\item{chrom}{Determines which column in \code{data} contains chromosome
information. If \code{NULL} tries to autodetect the column.}

\item{pos}{Determines which column in \code{data} contains position information.
If \code{NULL} tries to autodetect the column.}

\item{p}{Determines which column in \code{data} contains SNP p-values.
If \code{NULL} tries to autodetect the column.}

\item{yvar}{Specifies column in \code{data} for plotting on the y axis as an
alternative to specifying p-values. Both \code{p} and \code{yvar} cannot be specified
simultaneously.}

\item{labs}{Determines which column in \code{data} contains SNP rs IDs.
If \code{NULL} tries to autodetect the column.}

\item{index_snp}{Specifies the index SNP. If not specified, the SNP with the
lowest P value is selected.}

\item{LD}{Optional character value to specify which column in \code{data} contains
LD information.}
}
\value{
Returns an object of class 'locus' ready for plotting, containing
the subset of GWAS data to be plotted,
chromosome and genomic position range,
Ensembl database version number,
column names for chromosome, position, SNP ID, p-value or variable for
plotting on y axis,
locus gene information from Ensembl and
locus exon information from Ensembl.
}
\description{
Creates object of class 'locus' for genomic locus plot similar to
\code{locuszoom}.
}
\details{
This is an R version of \code{locuszoom} (http://locuszoom.org) for generating
publication ready Manhattan plots of gene loci. It references Ensembl
databases using the \code{ensembldb} Bioconductor package framework for annotating
genes and exons in the locus.
}
\examples{
## Bioconductor package EnsDb.Hsapiens.v75 is needed for these examples
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'UBE2L3', flank = 1e5,
             ens_db = "EnsDb.Hsapiens.v75")
summary(loc)
locus_plot(loc)
loc2 <- locus(SLE_gwas_sub, gene = 'STAT4', flank = 1e5,
              ens_db = "EnsDb.Hsapiens.v75")
locus_plot(loc2)
}
}
