% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_recomb.R
\name{link_recomb}
\alias{link_recomb}
\title{Query UCSC for Recombination data}
\usage{
link_recomb(loc, genome = "hg38", table = NULL)
}
\arguments{
\item{loc}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}}

\item{genome}{Either \code{"hg38"} or \code{"hg19"}}

\item{table}{Optional character value specifying which recombination table to
use.}
}
\value{
A list object of class 'locus'. Recombination data is added as list
element \code{recomb}.
}
\description{
Adds recombination data to a 'locus' object by querying UCSC genome browser.
}
\details{
Uses the \code{rtracklayer} package to query UCSC genome browser for recombination
rate data. The results are cached using \code{memoise} to reduce API requests.

Possible options for \code{table} for hg19 are \code{"hapMapRelease24YRIRecombMap"},
\code{"hapMapRelease24CEURecombMap"}, \code{"hapMapRelease24CombinedRecombMap"} (the
default).

The only option for \code{table} for hg38 is \code{"recomb1000GAvg"} (the default).
}
