% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{layout_glue_generator}
\alias{layout_glue_generator}
\title{Generate log layout function using common variables available via glue syntax}
\usage{

  layout_glue_generator(format = "{level} [{format(time, \\"\%Y-\%d-\%m \%H:\%M:\%S\\")}] {msg}")
}
\arguments{
\item{format}{\code{glue}-flavored layout of the message using the above variables}
}
\value{
function taking \code{level} and \code{msg} arguments - keeping the original call creating the generator in the \code{generator} attribute that is returned when calling \code{\link{log_layout}} for the currently used layout
}
\description{
\code{format} is passed to \code{glue} with access to the below variables:
\itemize{
 \item msg: the actual log message
 \item further variables set by \code{\link{get_logger_meta_variables}}
}
}
\examples{
\dontrun{
example_layout <- layout_glue_generator(
  format = '{node}/{pid}/{ns}/{ans}/{topenv}/{fn} {time} {level}: {msg}')
example_layout(INFO, 'try {runif(1)}')

log_layout(example_layout)
log_info('try {runif(1)}')
}
}
\seealso{
See example calls from \code{\link{layout_glue}} and \code{\link{layout_glue_colors}}.
}
