% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubletruncation.R
\name{test_ditrunc_elife}
\alias{test_ditrunc_elife}
\title{Likelihood ratio test for doubly interval truncated data}
\usage{
test_ditrunc_elife(
  time,
  covariate,
  thresh = 0,
  ltrunc1 = NULL,
  rtrunc1 = NULL,
  ltrunc2 = NULL,
  rtrunc2 = NULL,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "extweibull", "perks",
    "beard", "perksmake", "beardmake"),
  weights = rep(1, length(time)),
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{covariate}{vector of factors, logical or integer whose distinct values are}

\item{thresh}{vector of thresholds}

\item{family}{string; choice of parametric family}

\item{weights}{weights for observations}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
a list with elements
\itemize{
\item \code{stat}: likelihood ratio statistic
\item \code{df}: degrees of freedom
\item \code{pval}: the p-value obtained from the asymptotic chi-square approximation.
}
}
\description{
This function fits separate models for each distinct
value of covariates and computes a likelihood ratio test
to test whether there are significant differences between
groups.
}
\keyword{internal}
