% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLData_transform.R
\name{transform}
\alias{transform}
\title{Transform an LPJmLData object}
\usage{
transform(x, to)
}
\arguments{
\item{x}{An \link{LPJmLData} object.}

\item{to}{A character vector defining space and/or time format into which
the corresponding data dimensions should be transformed. Choose from space
formats \code{c("cell", "lon_lat")} and time formats
\code{c("time","year_month_day")}.}
}
\value{
An \code{\link{LPJmLData}} object in the selected format.
}
\description{
Function to transform an \code{\link{LPJmLData}} data object into another
space or another time format. Combinations of space and time formats are also
possible.
}
\examples{
\dontrun{

runoff <- read_io(filename = "runoff.bin.json",
                  subset = list(year = as.character(1991:2000)))

# Transform into space format "lon_lat". This assumes a "grid.bin.json" file
# is present in the same directory as "runoff.bin.json".
transform(runoff, to = "lon_lat")
# [...]
# $data |>
#   dimnames() |>
#     .$lat  "-55.75" "-55.25" "-54.75" "-54.25" ... "83.75"
#     .$lon  "-179.75" "-179.25" "-178.75" "-178.25" ... "179.75"
#     .$time  "1991-01-31" "1991-02-28" "1991-03-31" "1991-04-30" ...
#     .$band  "1"
# [...]

# Transform time format from a single time dimension into separate dimensions
# for years, months, and days. Dimensions for time steps not present in the
# data are omitted, i.e. no "day" dimension for monthly data.
transform(runoff, to = "year_month_day")
# [...]
# $data |>
#   dimnames() |>
#     .$lat  "-55.75" "-55.25" "-54.75" "-54.25" ... "83.75"
#     .$lon  "-179.75" "-179.25" "-178.75" "-178.25" ... "179.75"
#     .$month  "1" "2" "3" "4" ... "12"
#     .$year  "1991" "1992" "1993" "1994" ... "2000"
#     .$band  "1"
# [...]
}

}
