# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Quantile function of truncated piecewise exponential distribution
#' @description Obtains the quantile of a piecewise expoenential distribution
#' given that it exceeds a specified lower bound.
#'
#' @param probability The scalar probability corresponding to the quantile.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @param lowerBound The left truncation time point for the survival time.
#' Defaults to 0 for no truncation.
#'
#' @return The quantile x such that
#' P(X > x | X > lowerBound) = 1 - probability.
#'
#' @keywords internal
#'
#' @examples
#' qtpwexp(probability = 0.3, piecewiseSurvivalTime = c(0, 6, 9, 15),
#'         lambda = c(0.025, 0.04, 0.015, 0.007))
#'
#' @export
qtpwexp <- function(probability = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, lowerBound = 0) {
    .Call(`_lrstat_qtpwexp`, probability, piecewiseSurvivalTime, lambda, lowerBound)
}

#' @title Log-rank test simulation
#' @description Performs simulation for two-arm group sequential superiority
#' trials based on log-rank test.
#'
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_criticalValues
#' @inheritParams param_futilityBounds
#' @param allocation1 Number of subjects in the active treatment group in
#' a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in the control group in
#' a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of events at each
#' stage.
#' @param maxNumberOfIterations The number of simulation iterations.
#' Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#' to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#' The computer clock will be used if left unspecified,
#'
#' @return A list of S3 class lrsim with 3 components: sumstat is a list of
#' the operating characteristics of the design, sumdata is a data frame for
#' the summary data for each iteration, and rawdata is a data frame for
#' selected raw data if maxNumberOfRawDatasetsPerStage is a positive integer.
#'
#' @examples
#' sim = lrsim(kMax = 2, informationRates = c(0.5, 1),
#'             criticalValues = c(2.797, 1.977),
#'             accrualIntensity = 11,
#'             lambda1 = 0.018, lambda2 = 0.030,
#'             accrualDuration = 12,
#'             plannedEvents = c(60, 120),
#'             maxNumberOfIterations = 1000,
#'             maxNumberOfRawDatasetsPerStage = 1,
#'             seed = 314159)
#'
#' # summary statistics
#' sim
#'
#' # summary for each simulated data set
#' head(sim$sumdata)
#'
#' # raw data for selected replication
#' head(sim$rawdata)
#'
#' @export
lrsim <- function(kMax = NA_integer_, informationRates = NA_real_, criticalValues = NA_real_, futilityBounds = NA_real_, allocation1 = 1L, allocation2 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim`, kMax, informationRates, criticalValues, futilityBounds, allocation1, allocation2, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Number of enrolled subjects
#' @description Obtains the number of subjects enrolled by given calendar
#' times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of enrolled subjects.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_accrualDuration
#'
#' @return A vector of total number of subjects enrolled by the
#' specified calendar times.
#'
#' @examples
#' # Example 1: Uniform enrollment with 20 patients per month for 12 months.
#' accrual(time = 3, accrualTime = 0, accrualIntensity = 20,
#'         accrualDuration = 12)
#'
#' # Example 2: Piecewise accrual, 10 patients per month for the first
#' # 3 months, and 20 patients per month thereafter. Patient recruitment
#' # ends at 12 months for the study.
#' accrual(time = c(2, 9), accrualTime = c(0, 3),
#'         accrualIntensity = c(10, 20), accrualDuration = 12)
#'
#' @export
accrual <- function(time = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, accrualDuration = NA_real_) {
    .Call(`_lrstat_accrual`, time, accrualTime, accrualIntensity, accrualDuration)
}

#' @title Probability of being at risk
#' @description Obtains the probability of being at risk at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of being at risk.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of being at risk at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#' patrisk(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'         lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
patrisk <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_patrisk`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Probability of having an event
#' @description Obtains the probability of having an event at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of having an event.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of having an event at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#' pevent(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'        lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pevent <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pevent`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval with constant hazard
#' @description Obtains the integration probability of having an event
#' during an interval with constant hazard.
#'
#' @param j The analysis time interval with constant hazard.
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval with constant hazard for a treatment
#' group with specified piecewise exponential survival and dropout
#' distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#' hd(j = 1, t1 = 1, t2 = 3, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
hd <- function(j = NA_integer_, t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_hd`, j, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval
#' @description Obtains the integration of the probability of having an event
#' during an interval. The specified analysis time interval can span more
#' than one analysis time interval with constant hazard.
#'
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval for a treatment group with specified
#' piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#' pd(t1 = 1, t2 = 8, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pd <- function(t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pd`, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of patients enrolled during an interval and having an event
#' by specified calendar times
#' @description Obtains the number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @param u1 Lower bound of the accrual time interval.
#' @param u2 Upper bound of the accrual time interval.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times for a given treatment group had the enrollment being
#' restricted to the treatment group. By definition, we must have
#' \code{time >= u2}.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, 10 patients per month for the first 3 months, and
#' # 20 patients per month thereafter. Piecewise exponential survival with
#' # hazard 0.0533 in the first 6 months, and hazard 0.0309 thereafter,
#' # and 5% dropout by the end of 1 year.
#' ad(time = c(9, 15), u1 = 1, u2 = 8, accrualTime = c(0, 3),
#'    accrualIntensity = c(10, 20), piecewiseSurvivalTime=c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
ad <- function(time = NA_real_, u1 = NA_real_, u2 = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_ad`, time, u1, u2, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of subjects at risk
#' @description Obtains the number of subjects at risk at given analysis
#' times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients at risk.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients at risk at the specified
#' analysis times for each treatment group.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' natrisk(time = c(9, 24), allocationRatioPlanned = 1, accrualTime = c(0, 3),
#'         accrualIntensity = c(10, 20), piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18, maxFollowupTime = 30)
#'
#' @export
natrisk <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_natrisk`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event
#' @description Obtains the number of subjects having an event by given
#' analysis times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' analysis times for each treatment group.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' nevent(time = c(9, 24), allocationRatioPlanned = 1, accrualTime = c(0, 3),
#'        accrualIntensity = c(10, 20), piecewiseSurvivalTime = c(0, 6),
#'        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'        gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 12, minFollowupTime = 18, maxFollowupTime = 30)
#'
#' @export
nevent <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event by calendar time
#' @description Obtains the number of subjects having an event by given
#' calendar times for each treatment group.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' calendar times for each treatment group.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' nevent2(time = c(9, 24), allocationRatioPlanned = 1, accrualTime = c(0, 3),
#'         accrualIntensity = c(10, 20), piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18, maxFollowupTime = 30)
#'
#' @export
nevent2 <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent2`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event and log-rank statistics
#' @description Obtains the number of subjects having an event in each
#' treatment group, the mean and variance of weighted log-rank test score
#' statistic at given calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#'   of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictEventOnly Whether to predict the number of events only.
#'   Defaults to 0 for obtaining log-rank test score statistic mean
#'   and variance.
#'
#' @return A data frame of the number of patients enrolled, the number of
#' patients having an event overall and in each treatment group, the mean and
#' variance of weighted log-rank test score statistic at the specified
#' calendar times by stratum.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' lrstat(time = c(22, 40), allocationRatioPlanned = 1,
#'        accrualTime = seq(0, 9),
#'        accrualIntensity = c(26/9*seq(1, 9), 26),
#'        piecewiseSurvivalTime = c(0, 6),
#'        stratumFraction = c(0.2, 0.8),
#'        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'        gamma1 = -log(1-0.05)/12,
#'        gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 22,
#'        followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictEventOnly = 0L) {
    .Call(`_lrstat_lrstat`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictEventOnly)
}

#' @title Calendar times for target number of events
#' @description Obtains the calendar times to reach the target number of
#' subjects having an event.
#'
#' @param nevents A vector of target number of events.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#'
#' @return A vector of calendar times expected to yield the target
#' number of events.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' caltime(nevents = c(24, 80), allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
caltime <- function(nevents = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L) {
    .Call(`_lrstat_caltime`, nevents, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup)
}

#' @title Stagewise exit probabilities
#' @description Obtains the stagewise exit probabilities for both efficacy and
#' futility stopping.
#'
#' @param b Upper boundaries on the z-test statistic scale.
#' @param a Lower boundaries on the z-test statistic scale. Defaults to
#' \code{c(rep(-Inf, kMax-1), b[kMax])} if left unspecified, where
#' \code{kMax = length(b)}.
#' @param theta Stagewise parameter of interest, e.g., \code{-U/V} for
#' weighted log-rank test, where \code{U} is the mean and \code{V} is
#' the variance of the weighted log-rank test score statistic at each stage.
#' For proportional hazards and conventional log-rank test, use the
#' scalar input, \code{theta = -log(HR)}.
#' @param I Stagewise cumulative information, e.g., \code{V}, the variance
#' of the weighted log-rank test score statistic at each stage. For
#' conventional log-rank test, information can be approximated by
#' \code{phi*(1-phi)*D}, where \code{phi} is the probability of being
#' allocated to the active arm, and \code{D} is the total number of events at
#' each stage.
#' @param r Integer value controlling grid for numerical integration as in
#' Jennison and Turnbull (2000). Defaults to 18. Specify a larger number
#' for greater accuracy.
#'
#' @return A list of stagewise exit probabilities: one vector for efficacy
#' stopping probabilities, and the other vector for futility stopping
#' probabilities.
#'
#' @examples
#' exitprob(b = c(3.471, 2.454, 2.004), theta = -log(0.6),
#'          I = c(50, 100, 150)/4)
#'
#' @export
exitprob <- function(b = NA_real_, a = NA_real_, theta = NA_real_, I = NA_real_, r = 18L) {
    .Call(`_lrstat_exitprob`, b, a, theta, I, r)
}

#' @title Log-rank test power
#' @description Estimates the power, stopping probabilities, and expected
#' sample size in a two-group survival design.
#'
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_criticalValues
#' @inheritParams param_futilityBounds
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#'
#' @return A list of the overall and stagewise rejection probabilities, the
#' futility stoppig probabilities, the overall and stagewise expected number
#' of events, number of patients, and analysis time, the input accrual and
#' follow-up durations, and whether a fixed follow-up is used.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrpower(kMax = 2, informationRates = c(0.8, 1),
#'         criticalValues = c(2.250, 2.025),
#'         allocationRatioPlanned = 1, accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12, accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrpower <- function(kMax = NA_integer_, informationRates = NA_real_, criticalValues = NA_real_, futilityBounds = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L) {
    .Call(`_lrstat_lrpower`, kMax, informationRates, criticalValues, futilityBounds, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals)
}

#' @title Log-rank test sample size
#' @description Obtains the needed accrual duration given power and
#' follow-up time, or the needed follow-up time given power and
#' accrual duration in a two-group survival design.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_criticalValues
#' @inheritParams param_futilityBounds
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param interval The interval to search for the solution of
#' accrualDuration or followupDuration. Defaults to \code{c(0.001, 240)}.
#' Adjustment may be needed for non-monotone relationship with study power.
#'
#' @return A list of the overall and stagewise rejection probabilities,  the
#' futility stoppig probabilities, the overall and stagewise expected number
#' of events, number of patients, and analysis time, the input or calculated
#' accrual and follow-up durations, and whether a fixed follow-up is used.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' # Example 1: Obtains accrual duration given power and follow-up duration
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              criticalValues = c(2.250, 2.025),
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = NA,
#'              followupTime = 18, fixedFollowup = FALSE)
#'
#' # Example 2: Obtains follow-up duration given power and accrual duration
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              criticalValues = c(2.250, 2.025),
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = NA, fixedFollowup = FALSE)
#'
#' @export
lrsamplesize <- function(beta = 0.2, kMax = NA_integer_, informationRates = NA_real_, criticalValues = NA_real_, futilityBounds = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, interval = as.numeric( c(0.001, 240))) {
    .Call(`_lrstat_lrsamplesize`, beta, kMax, informationRates, criticalValues, futilityBounds, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, interval)
}

#' @title Set seed
#' @description Sets the R seed in the cpp program based on set.seed() in R.
#'
#' @param seed The seed to use for generating random numbers.
#' @return No return value, called for side effects.
#'
#' @keywords internal
#'
#' @examples
#' set_seed(123)
#'
#' @export
set_seed <- function(seed) {
    invisible(.Call(`_lrstat_set_seed`, seed))
}

#' @title Sort a numeric vector
#' @description Sorts a numeric vector in the cpp program.
#'
#' @param x The numeric vector to sort.
#' @return A vector obtained after sorting the input vector.
#'
#' @keywords internal
#'
#' @examples
#' stl_sort(c(3, 4.2, 1))
#'
#' @export
stl_sort <- function(x) {
    .Call(`_lrstat_stl_sort`, x)
}

#' @title Find interval numbers of indices
#' @description The implementation of \code{findInterval()} in R from Advanced
#' R by Hadley Wickham. Given a vector of non-decreasing breakpoints in v,
#' find the interval containing each element of x; i.e., if
#' \code{i <- findInterval2(x,v)}, for each index \code{j} in \code{x},
#' v[i[j]] ≤ x[j] < v[i[j] + 1]
#' where v[0] := -Inf, v[N+1] := +Inf, and \code{N = length(v)}.
#'
#' @param x The numeric vector of interest.
#' @param v The vector of break points.
#' @return A vector of \code{length(x)} with values in \code{0:N} where
#'   \code{N = length(v)}.
#'
#' @keywords internal
#'
#' @examples
#' x <- 2:18
#' v <- c(5, 10, 15) # create two bins [5,10) and [10,15)
#' cbind(x, findInterval2(x, v))
#'
#' @export
findInterval2 <- function(x, v) {
    .Call(`_lrstat_findInterval2`, x, v)
}

