% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrstat}
\alias{lrstat}
\title{Number of Subjects Having an Event and Log-Rank Statistics}
\usage{
lrstat(
  time = NA_real_,
  hazardRatioH0 = 1,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  numSubintervals = 300L,
  predictTarget = 2L
)
}
\arguments{
\item{time}{A vector of calendar times at which to calculate the number
of events and the mean and variance of log-rank test score statistic.}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{numSubintervals}{Number of sub-intervals to approximate the mean
and variance of the weighted log-rank test score statistic.
Defaults to 300. Specify a larger number for better approximation.}

\item{predictTarget}{The target of prediction.
Set \code{predictTarget = 1} to predict the number of events only.
Set \code{predictTarget = 2} (default) to predict the number of events
and log-rank score statistic mean and variance.
Set \code{predictTarget = 3} to predict the number of events,
log-rank score statistic mean and variance, and
hazard ratio and variance of log hazard ratio.}
}
\value{
A data frame containing the following variables if
\code{predictTarget = 1}:
\itemize{
\item \code{time}: The analysis time since trial start.
\item \code{subjects}: The number of enrolled subjects.
\item \code{nevents}: The total number of events.
\item \code{nevents1}: The number of events in the active treatment group.
\item \code{nevents2}: The number of events in the control group.
\item \code{ndropouts}: The total number of dropouts.
\item \code{ndropouts1}: The number of dropouts in the active treatment
group.
\item \code{ndropouts2}: The number of dropouts in the control group.
\item \code{nfmax}: The total number of subjects reaching maximum follow-up.
\item \code{nfmax1}: The number of subjects reaching maximum follow-up in
the active treatment group.
\item \code{nfmax2}: The number of subjects reaching maximum follow-up in
the control group.
}

If \code{predictTarget = 2}, the following variables will also
be included:
\itemize{
\item \code{uscore}: The numerator of the log-rank test statistic.
\item \code{vscore}: The variance of the log-rank score test statistic.
\item \code{logRankZ}: The log-rank test statistic on the Z-scale.
\item \code{hazardRatioH0}: The hazard ratio under the null hypothesis.
}

Furthermore, if \code{predictTarget = 3}, the following additional
variables will also be included:
\itemize{
\item \code{HR}: The average hazard ratio from weighted Cox regression.
\item \code{vlogHR}: The variance of log hazard ratio.
\item \code{zlogHR}: The Z-statistic for log hazard ratio.
}
}
\description{
Obtains the number of subjects accrued, number of events,
number of dropouts, and number of subjects reaching the maximum
follow-up in each group, mean and variance of weighted log-rank
score statistic, estimated hazard ratio from weighted Cox regression
and variance of log hazard ratio estimate at given calendar times.
}
\examples{
# Piecewise accrual, piecewise exponential survivals, and 5\% dropout by
# the end of 1 year.

lrstat(time = c(22, 40), allocationRatioPlanned = 1,
       accrualTime = seq(0, 8),
       accrualIntensity = 26/9*seq(1, 9),
       piecewiseSurvivalTime = c(0, 6),
       lambda1 = c(0.0533, 0.0309),
       lambda2 = c(0.0533, 0.0533),
       gamma1 = -log(1-0.05)/12,
       gamma2 = -log(1-0.05)/12,
       accrualDuration = 22,
       followupTime = 18, fixedFollowup = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
