# Runs the function multicompLetters from the multcompView package
# returns an error if not installed
.mcletters = function(..., Letters=c("1234567890",LETTERS,letters)) {
    if(!requireNamespace("multcompView", quietly = TRUE)) {
        message("The 'multcompView' package must be installed to use cld methods")
        return (list(monospacedLetters = "?"))
    }
    
    # Expand strings to individual letters
    Letters = as.character(unlist(sapply(Letters, function(stg) {
        sapply(seq_len(nchar(stg)), function(i) substr(stg, i, i))
    })))
    
    result = multcompView::multcompLetters(..., Letters=Letters)
    if (is.null(result$monospacedLetters))
        result$monospacedLetters = result$Letters
    result
}

# S3 method for ref.grid
cld.ref.grid = function(object, details=FALSE, sort=TRUE, 
                    by, alpha=.05, 
                    Letters = c("1234567890",LETTERS,letters), ...) {
    lsmtbl = summary(object, ...)
    if(missing(by)) 
        by = object@misc$by.vars
    if (sort) {
        args = list()
        for (nm in by) args[[nm]] = lsmtbl[[nm]]
        args$.lsm. = lsmtbl[[object@misc$estName]]
        ord = do.call("order", args)
        lsmtbl = lsmtbl[ord, ]
        object@grid = object@grid[ord, , drop=FALSE]
        object@linfct = object@linfct[ord, , drop = FALSE]
    }
    attr(lsmtbl, "by.vars") = by
    object@misc$by.vars = by
    
    prwise = contrast(object, "revpairwise", by=by)    
    pwtbl = test(prwise, ...)
    
    p.boo = (pwtbl$p.value < alpha)
    if(is.null(by)) {
        by.rows = list(seq_len(nrow(pwtbl)))
        by.out = list(seq_len(nrow(lsmtbl)))
    }
    else {
        by.rows = .find.by.rows(pwtbl, by)
        by.out = .find.by.rows(lsmtbl, by)
    }
    # Create comps matrix reflecting order generated by pairwise.lsmc
    icol = jcol = numeric(0)
    # create fake row indexes in revpairwise order for use by .mcletters
    k = length(by.out[[1]])
    for (i in 2:k) {
        icol = c(icol, seq_len(i-1))
        jcol = c(jcol, rep(i, i-1))
    }
    na.p = which(is.na(p.boo))
    # Take care of non-est cases. This is surprisingly complicated,
    # because it's possible we have some lsmeans that are non-est
    # but comparisons are est'ble. So cases to exclude must be missing in
    # the table of means, AND appar somewhere in the indexes of NA p values
    # All that said, it still messes up because I didn't track the indexes correctly
    # excl.rows = intersect(which(is.na(lsmtbl$SE)), union(icol[na.p], jcol[na.p]))
    # So I'll just go with which est's are missing
    excl.rows = which(is.na(lsmtbl$SE))
    p.boo[na.p] = FALSE
    
    labs = paste(icol,jcol,sep="-")
    ltrs = rep("", nrow(lsmtbl))
    for (i in seq_len(length(by.rows))) {
        pb = p.boo[by.rows[[i]]]
        names(pb) = labs
        mcl = .mcletters(pb, Letters=Letters)$monospacedLetters
        ltrs[by.out[[i]]] = paste(" ", mcl, sep="")
    }
    # any missing estimates get blanks...
    ltrs[excl.rows] = ""
    
    lsmtbl[[".group"]] = ltrs
    
    attr(lsmtbl, "mesg") = c(attr(lsmtbl,"mesg"), attr(pwtbl, "mesg"), 
                             paste("significance level used: alpha =", alpha))
        
    if (details)
        list(lsmeans = lsmtbl, comparisons = pwtbl)
    else
        lsmtbl
}
