% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsnstat_metadata.R
\name{lsnstat_metadata}
\alias{lsnstat_metadata}
\title{Metadata query function for \link{lsnstat_macrodata} requests.}
\usage{
lsnstat_metadata(dataset, param)
}
\arguments{
\item{dataset}{dataset requested : list available through \link{get_lsn_dataset_list} (required)}

\item{param}{list of dataset 'params' available for a dataset (optional)}
}
\value{
A \code{\link[=data.frame]{data.frame()}}.
}
\description{
Metadata query function for \link{lsnstat_macrodata} requests.
}
\examples{

# GET 'figaro_main_aggregates' (Sectoral production accounts from FIGARO)
# table parameters and codes.

lsnstat_metadata(dataset = "figaro_main_aggregates")

# GET 'figaro_intermediate_inputs' (flattened intermediate flows matrix from FIGARO)
# filters for parameter 'use_country'.

lsnstat_metadata("figaro_intermediate_inputs",param = "use_country")

}
