% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lspkselect.R
\name{lspkselect}
\alias{lspkselect}
\alias{print.lspkselect}
\alias{summary.lspkselect}
\title{Tuning Parameter Selection Procedures for Partitioning-Based Regression Estimation and Inference}
\usage{
lspkselect(y, x, m = NULL, m.bc = NULL, smooth = NULL,
  bsmooth = NULL, deriv = NULL, method = "bs", ktype = "uni",
  kselect = "imse-dpi", proj = TRUE, bc = "bc3", vce = "hc2",
  subset = NULL, rotnorm = TRUE)

\method{print}{lspkselect}(x, ...)

\method{summary}{lspkselect}(object, ...)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Independent variable. A matrix or data frame.}

\item{m}{Order of basis used in the main regression. Default is \code{m=2}.}

\item{m.bc}{Order of basis used to estimate leading bias. Default is \code{m.bc=m+1}.}

\item{smooth}{Smoothness of B-splines for point estimation. When \code{smooth=s}, B-splines have \code{s}-order
continuous derivatives. Default is \code{smooth=m-2}.}

\item{bsmooth}{Smoothness of B-splines for bias correction. Default is \code{bsmooth=m.bc-2}.}

\item{deriv}{Derivative order of the regression function to be estimated. A vector object of the same
length as \code{ncol(x)}. Default is \code{deriv=c(0,...,0)}.}

\item{method}{Type of basis used for expansion. Options are \code{"bs"} for B-splines,
\code{"wav"} for compactly supported wavelets (Cohen, Daubechies and Vial, 1993),
and \code{"pp"} for piecewise polynomials. Default is \code{method="bs"}.}

\item{ktype}{Knot placement. Options are \code{"uni"} for evenly spaced knots over the
support of \code{x} and \code{"qua"} for quantile-spaced knots. Default is \code{ktype="uni"}.}

\item{kselect}{Method for selecting the number of inner knots used by \code{lspkselect}. Options
are \code{"imse-rot"} for a rule-of-thumb (ROT) implementation of IMSE-optimal number of knots,
\code{"imse-dpi"} for second generation direct plug-in (DPI) implementation of IMSE-optimal number
of knots, and \code{"all"} for both. Default is \code{kselect="imse-dpi"}.}

\item{proj}{If \code{TRUE}, projection of leading approximation error onto the lower-order approximating space
is included for bias correction (splines and piecewise polynomial only). Default is \code{proj=TRUE}.}

\item{bc}{Bias correction method. Options are \code{"bc1"} for higher-order-basis bias correction,
\code{"bc2"} for least squares bias correction, and \code{"bc3"} for plug-in bias correction.
Defaults are \code{"bc3"} for splines and piecewise polynomials and \code{"bc2"}
for wavelets.}

\item{vce}{Procedure to compute the heteroskedasticity-consistent (HCk) variance-covariance matrix estimator with plug-in residuals. Options are
\itemize{
\item \code{"hc0"} for unweighted residuals (HC0).
\item \code{"hc1"} for HC1 weights.
\item \code{"hc2"} for HC2 weights. Default.
\item \code{"hc3"} for HC3 weights.
}}

\item{subset}{Optional rule specifying a subset of observations to be used.}

\item{rotnorm}{If \code{TRUE}, ROT selection is adjusted using normal densities.}

\item{...}{further arguments}

\item{object}{class \code{lspkselect} objects.}
}
\value{
\item{\code{ks}}{A matrix may contain \code{k.rot} (IMSE-optimal number of knots for
                        the main regression through ROT implementation), \code{k.bias.rot}
                        (IMSE-optimal number of knots for bias correction through ROT
                        implementation), \code{k.dpi} (IMSE-optimal number of knots for the
                        main regression through DPI implementation), \code{k.bias.dpi} (IMSE-optimal
                        number of knots for bias correction through DPI implementation)}
       \item{\code{opt}}{A list containing options passed to the function.}
}
\description{
\code{lspkselect} implements data-driven procedures to select the Integrated Mean Squared Error (IMSE) optimal number of partitioning knots for partitioning-based least squares regression estimators. Three series methods are supported: B-splines, compactly supported wavelets, and piecewise polynomials.
            See \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Cattaneo and Farrell (2013)} and \href{https://arxiv.org/abs/1804.04916}{Cattaneo, Farrell and Feng (2019a)} for complete details.

            Companion commands: \code{\link{lsprobust}} for partitioning-based least squares regression estimation and inference; \code{\link{lsprobust.plot}} for plotting results; \code{\link{lsplincom}} for multiple sample estimation and inference.

            A detailed introduction to this command is given in \href{https://arxiv.org/abs/1906.00202}{Cattaneo, Farrell and Feng (2019b)}.

            For more details, and related Stata and R packages useful for empirical analysis,
            visit \url{https://sites.google.com/site/nppackages/}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: \code{print} method for class "\code{lspkselect}".

\item \code{summary}: \code{summary} method for class "\code{lspkselect}".
}}

\examples{
x   <- data.frame(runif(500), runif(500))
y   <- sin(4*x[,1])+cos(x[,2])+rnorm(500)
est <- lspkselect(y, x)
summary(est)

}
\references{
Cattaneo, M. D., and M. H. Farrell (2013): \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Optimal convergence rates, Bahadur representation, and asymptotic normality of partitioning estimators}. Journal of Econometrics 174(2): 127-143.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2019a): \href{https://arxiv.org/abs/1804.04916}{Large Sample Properties of Partitioning-Based Series Estimators}. Annals of Statistics, forthcoming. arXiv:1804.04916.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2019b): \href{https://arxiv.org/abs/1906.00202}{lspartition: Partitioning-Based Least Squares Regression}. R Journal, forthcoming. arXiv:1906.00202.

Cohen, A., I. Daubechies, and P.Vial (1993): Wavelets on the Interval and Fast Wavelet Transforms. Applied and Computational Harmonic Analysis 1(1): 54-81.
}
\seealso{
\code{\link{lsprobust}}, \code{\link{lsprobust.plot}}, \code{\link{lsplincom}}
}
\author{
Matias D. Cattaneo, Princeton University, Princeton, NJ. \email{cattaneo@princeton.edu}.

Max H. Farrell, University of Chicago, Chicago, IL. \email{max.farrell@chicagobooth.edu}.

Yingjie Feng (maintainer), Princeton University, Princeton, NJ. \email{yingjief@princeton.edu}.
}
