% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_demo.R
\name{palette_demo}
\alias{palette_demo}
\title{Demonstrate Extracted Palette with HEX Labels - Base Plot Edition}
\usage{
palette_demo(
  palette,
  export = FALSE,
  export_name = "my_palette",
  export_path = getwd()
)
}
\arguments{
\item{palette}{(character) Vector of hexadecimal codes like that returned by `palette_extract()`, `..._sort()`, or `..._subsample()`}

\item{export}{(logical) Whether or not to export the demo plot}

\item{export_name}{(character) Name for exported plot}

\item{export_path}{(character) File path to save exported plot (defaults to working directory)}
}
\value{
A plot of the retrieved colors labeled with their HEX codes
}
\description{
Accepts the hexadecimal code vector returned by `palette_extract()`, `..._sort()`, or `..._subsample()` and 
   creates a base plot of all returned colors labeled with their HEX codes. This will facilitate (hopefully) your selection of 
   which of the 25 colors you would like to use in a given context.
}
\examples{
# Extract colors from a supplied image
my_colors <- palette_extract(
   image = system.file("extdata", "lyon-fire.png", package = "lterpalettefinder")
   )
       
# Plot that result
palette_demo(palette = my_colors)

}
