% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LUE_YIELD.r
\name{LUE_YIELD}
\alias{LUE_YIELD}
\title{Light Use Efficiency Model to Estimate Crop Yield}
\format{A Biomass raster}
\usage{
LUE_YIELD(fpar_raster,par,tmin,tmin_min,tmin_max,LUE_optimal)
}
\arguments{
\item{fpar_raster}{fraction of photosynthetically active radiation (fpar) per day raster with .tif format}

\item{par}{clear sky surface photosynthetically active radiation (par) per day raster with .nc file format.}

\item{tmin}{Minimum temperature at 2 metres since previous post-processing per day raster with .nc file format.}

\item{tmin_min}{minimum value of tmin used for the threshold}

\item{tmin_max}{maximum value of tmin used for the threshold}

\item{LUE_optimal}{optical lue value with respect to crop type for example wheat crop LUE_optimal is 3.0 (Djumaniyazova et al., 2010)}
}
\value{
Yield raster
}
\description{
Contains LUE_YIELD() to estimate aboveground biomass firstly by calculating the Absorbed Photosynthetically Active Radiation (APAR) and secondly the actual values of light use efficiency Shi et al.(2007) <doi:10.2134/agronj2006.0260>.
}
\examples{
\dontrun{
## load the data
data(fpar)
data(par1)
data(tmin)
LUE_YIELD(fpar,par1,tmin,-2,12,3)
}
library(raster)
fparr <- raster(nc=2, nr=2)
values(fparr)<-runif(ncell(fparr),min =0.2,max= 0.8)
par11<- brick(nc=2, nr=2, nl=2)
values(par11)<-runif(ncell(par11),min =169076.9,max= 924474.6)
tminn <- brick(nc=2, nr=2, nl=2)
values(tminn)<-runif(ncell(tminn),min = 278,max= 281)
LUE_YIELD(fparr,par11,tminn,-2,12,3)
}
\references{
Djumaniyazova Y, Sommer R, Ibragimov N, Ruzimov J, Lamers J & Vlek P (2010) Simulating water use and N response of winter wheat in the irrigated floodplains of Northwest Uzbekistan. Field Crops Research 116, 239-251.

Shi Z, Ruecker G R,Mueller M, Conrad C, Ibragimov N, Lamers J P A, Martius C, Strunz G, Dech S & Vlek P L G (2007) Modeling of Cotton Yields in the Amu Darya River Floodplains of Uzbekistan Integrating Multitemporal Remote Sensing and Minimum Field Data. Agronomy Journal 99, 1317-1326.
}
\keyword{datasets}
