% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone.R
\name{clone}
\alias{clone}
\alias{clone.lvec}
\title{Clone an lvec object}
\usage{
clone(x, ...)

\method{clone}{lvec}(x, ...)
}
\arguments{
\item{x}{\code{\link{lvec}} object to clone}

\item{...}{ignored; used to pass additional arguments to other methods}
}
\description{
Clone an lvec object
}
\details{
\code{\link{lvec}} objects are basically pointers to pieces of memory. 
When copying an object only the pointer is copied and when modifying the copied
object also the original object is modified. The advantage of this is speed: 
these is less copying of the complete vector. In order to obtain a true copy
of an \code{lvec} code can be used.
}
\examples{
a <- as_lvec(1:3)
# Copy
b <- a
# When modifying the copy also the original is modified
lset(b, 1, 10)
print(a)
print(b)
# Use clone to make a true copy
b <- clone(a)
lset(b, 1, 100)
print(a)
print(b)

}
