% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{mable.ctrl}
\alias{mable.ctrl}
\title{Control parameters for mable fit}
\usage{
mable.ctrl(
  sig.level = 0.01,
  eps = 1e-07,
  maxit = 5000L,
  eps.em = 1e-07,
  maxit.em = 5000L,
  eps.nt = 1e-07,
  maxit.nt = 100L,
  tini = 1e-04
)
}
\arguments{
\item{sig.level}{the sigificance level for change-point method of choosing
optimal model degree}

\item{eps}{convergence criterion for iteration involves EM like and Newton-Raphson iterations}

\item{maxit}{maximum number of iterations involve EM like and Newton-Raphson iterations}

\item{eps.em}{convergence criterion for EM like iteration}

\item{maxit.em}{maximum number of EM like iterations}

\item{eps.nt}{convergence criterion for Newton-Raphson iteration}

\item{maxit.nt}{maximum number of Newton-Raphson iterations}

\item{tini}{a small positive number used to make sure initial \code{p} 
is in the interior of the simplex}
}
\value{
a list of the arguments' values
}
\description{
Control parameters for mable fit
}
\author{
Zhong Guan <zguan@iusb.edu>
}
