% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sums.r
\docType{methods}
\name{colsums}
\alias{colsums}
\alias{colSums}
\alias{colSums,madness-method}
\alias{colMeans,madness-method}
\alias{colMeans}
\alias{rowSums,madness-method}
\alias{rowSums}
\alias{rowMeans,madness-method}
\alias{rowMeans}
\title{Form Row and Column Sums and Means}
\usage{
\S4method{colSums}{madness}(x, na.rm = FALSE, dims = 1)

\S4method{colMeans}{madness}(x, na.rm = FALSE, dims = 1)

\S4method{rowSums}{madness}(x, na.rm = FALSE, dims = 1)

\S4method{rowMeans}{madness}(x, na.rm = FALSE, dims = 1)
}
\arguments{
\item{x}{\code{madness} object.}

\item{na.rm}{logical.  Should missing values (including \code{NaN})
    be omitted from the calculations?}

\item{dims}{integer: Which dimensions are regarded as \sQuote{rows} or
    \sQuote{columns} to sum over.  For \code{row*}, the sum or mean is
    over dimensions \code{dims+1, \dots}; for \code{col*} it is over
    dimensions \code{1:dims}.}

\item{...}{potentially further arguments, for method \sQuote{<->} generic compatibility.}
}
\value{
a \code{madness} object. Note that the sums are flattened to a
column vector.
}
\description{
Form Row and Column Sums and Means for \code{madness} objects.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
