% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSource.R
\name{readSource}
\alias{readSource}
\title{readSource}
\usage{
readSource(type, subtype = NULL, convert = TRUE)
}
\arguments{
\item{type}{source type, e.g. "IEA". A list of all available source types
can be retrieved with function \code{\link{getSources}}.}

\item{subtype}{For some sources there are subtypes of the source, for these
source the subtype can be specified with this argument. If a source does not
have subtypes, subtypes should not be set.}

\item{convert}{Boolean indicating whether input data conversion
should be done or not. In addition it can be set to "onlycorrect" 
for sources with a separate correctXXX-function.}
}
\value{
magpie object with the temporal and data dimensionality of the
source data. Spatial will either agree with the source data or will be on
ISO code country level depending on your choice for the argument "convert".
}
\description{
Read in a source file and convert it to a MAgPIE object. The function is a
wrapper for specific functions designed for the different possible source
types.
}
\examples{

\dontrun{ 
a <- readSource("Tau","paper")
}

}
\seealso{
\code{\link{setConfig}}, ' \code{\link{downloadSource}}, 
\code{\link{readTau}}
}
\author{
Jan Philipp Dietrich, Anastasis Giannousakis, Lavinia Baumstark
}
