% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-catalogue_functions.R
\name{valueType_of}
\alias{valueType_of}
\title{Return the valueType of an object}
\usage{
valueType_of(x)
}
\arguments{
\item{x}{Object. Can be a vector.}
}
\value{
A character string which is the valueType of the input object.
}
\description{
Determines the valueType of an object based on \code{\link[base:typeof]{base::typeof()}} and
\code{\link[base:class]{base::class()}}. The possible values returned are 'date', 'boolean',
'integer', 'decimal', and 'text'.
}
\details{
The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

# use DEMO_files provided by the package

dataset <- DEMO_files$dataset_MELBOURNE_1
valueType_of(dataset$Gender)
valueType_of(iris$Sepal.Length)

}

}
\seealso{
\code{\link[base:typeof]{base::typeof()}}, \code{\link[base:class]{base::class()}}
\link{valueType_list} for insights about possible valueType and
translation into type and class in R.
\href{https://opaldoc.obiba.org/en/dev/magma-user-guide/value/type.html}{Opal documentation}
}
