% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magi-package.R
\name{is.magioutput}
\alias{is.magioutput}
\alias{magioutput}
\title{MagiSolver output (\code{magioutput}) object}
\usage{
is.magioutput(object)

magioutput(...)
}
\arguments{
\item{object}{an R object}

\item{...}{arguments required to create a magioutput object. See details.}
}
\value{
logical. Is the input a magioutput object?
}
\description{
Check for and create a magioutput object
}
\details{
Using the core \code{\link{MagiSolver}} function returns a \code{magioutput} object as output, which is a list that contains the following elements:
\describe{
\item{\code{theta}}{matrix of MCMC samples for the system parameters \eqn{\theta}, after burn-in.}
\item{\code{xsampled}}{array of MCMC samples for the system trajectories at each discretization time point, after burn-in.}
\item{\code{sigma}}{matrix of MCMC samples for the observation noise SDs \eqn{\sigma}, after burn-in.}
\item{\code{phi}}{matrix of estimated GP hyper-parameters, one column for each system component.}
\item{\code{lp}}{vector of log-posterior values at each MCMC iteration, after burn-in.}
} 
Printing a \code{magioutput} object displays a brief summary of the settings used for the \code{MagiSolver} run.
The summary method for a \code{magioutput} object prints a table of parameter estimates, see \code{\link{summary.magioutput}} for more details. 
Plotting a \code{magioutput} object shows the inferred trajectories for each component, see \code{\link{plot.magioutput}} for more details.
}
\examples{
# Set up odeModel list for the Fitzhugh-Nagumo equations
fnmodel <- list(
  fOde = fnmodelODE,
  fOdeDx = fnmodelDx,
  fOdeDtheta = fnmodelDtheta,
  thetaLowerBound = c(0, 0, 0),
  thetaUpperBound = c(Inf, Inf, Inf)
)

# Example FN data
data(FNdat)

# Create magioutput from a short MagiSolver run (demo only, more iterations needed for convergence)
result <- MagiSolver(FNdat, fnmodel, control = list(nstepsHmc = 5, niterHmc = 50)) 

is.magioutput(result)

}
