% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R
\name{editing}
\alias{editing}
\alias{image_read}
\alias{magick}
\alias{imagemagick}
\alias{image_write}
\alias{image_display}
\alias{image_browse}
\alias{image_append}
\alias{image_average}
\alias{image_coalesce}
\alias{image_flatten}
\alias{image_fft}
\alias{image_map}
\alias{image_montage}
\alias{image_morph}
\alias{image_mosaic}
\alias{image_join}
\alias{image_info}
\alias{image_animate}
\title{Image Editing}
\usage{
image_read(path, density = NULL, depth = NULL)

image_write(image, path = NULL, format = NULL, quality = NULL,
  depth = NULL, density = NULL, flatten = FALSE)

image_display(image, animate = TRUE)

image_browse(image, browser = getOption("browser"))

image_append(image, stack = FALSE)

image_average(image)

image_coalesce(image)

image_flatten(image, operator = NULL)

image_fft(image)

image_map(image, map, dither = FALSE)

image_montage(image)

image_morph(image, frames)

image_mosaic(image, operator = NULL)

image_join(...)

image_info(image)

image_animate(image, fps = 10, loop = 0, dispose = c("background",
  "previous", "none"))
}
\arguments{
\item{path}{file path, URL, or raw array or \code{nativeRaster} with image data}

\item{density}{resolution to render pdf or svg}

\item{depth}{image depth. Must be 8 or 16}

\item{image}{object returned by \code{image_read}}

\item{format}{output format such as \code{png}, \code{jpeg}, \code{gif} or \code{pdf}.
Can also be a bitmap type such as \code{rgba} or \code{rgb}.}

\item{quality}{number between 0 and 100 for jpeg quality. Defaults to 75.}

\item{flatten}{should image be flattened before writing? This also replaces
transparency with background color.}

\item{animate}{support animations in the X11 display}

\item{browser}{argument passed to \link[utils:browseURL]{browseURL}}

\item{stack}{place images top-to-bottom (TRUE) or left-to-right (FALSE)}

\item{operator}{string with a
\href{https://www.imagemagick.org/Magick++/Enumerations.html#CompositeOperator}{composite operator}.}

\item{map}{reference image to map colors from}

\item{dither}{set TRUE to enable dithering}

\item{frames}{number of frames to use in output animation}

\item{...}{images or lists of images to be combined into a image}

\item{fps}{frames per second}

\item{loop}{how many times to repeat the animation. Default is infinite.}

\item{dispose}{frame disposal method. See
\href{http://www.imagemagick.org/Usage/anim_basics/}{documentation}}
}
\description{
Read, write and join or combine images. All image functions are vectorized,
meaning they operate either on a single frame or a series of frames (e.g. a
collage, video, or animation).
The \href{https://www.imagemagick.org/Magick++/STL.html}{Magick++ documentation}
explains meaning of each function and parameter.
}
\details{
Besides these functions also R-base functions such as \code{c()}, \code{[},
\code{as.list()}, \code{as.raster()}, \code{rev}, \code{length}, and \code{print}
can be used to work with image frames.
See \link{transformations} for vectorized
image manipulation functions such as cutting and applying effects.

Some configurations of ImageMagick++ support reading SVG files but the rendering
is not always very pleasing. Better results can be obtained by first rendering
svg to a png using the \href{https://cran.r-project.org/package=rsvg}{rsvg package}.
}
\examples{
# Download image from the web
frink <- image_read("https://jeroen.github.io/images/frink.png")
worldcup_frink <- image_fill(frink, "orange", "+100+200", 30000)
image_write(worldcup_frink, "output.png")

# Plot to graphics device via legacy raster format
raster <- as.raster(frink)
par(ask=FALSE)
plot(raster)

# Read bitmap arrays
curl::curl_download("https://www.r-project.org/logo/Rlogo.png", "Rlogo.png")
image_read(png::readPNG("Rlogo.png"))

curl::curl_download("https://jeroen.github.io/images/example.webp", "example.webp")
image_read(webp::read_webp("example.webp"))

curl::curl_download("http://jeroen.github.io/images/tiger.svg", "tiger.svg")
image_read(rsvg::rsvg("tiger.svg"))
# Create thumbnails from GIF
banana <- image_read("https://jeroen.github.io/images/banana.gif")
length(banana)
image_average(banana)
image_flatten(banana)
image_append(banana)
image_append(banana, stack = TRUE)

# Append images together
image_append(image_scale(c(image_append(banana[c(1,3)], stack = TRUE), frink)))
# Combine with another image
logo <- image_read("https://www.r-project.org/logo/Rlogo.png")
oldlogo <- image_read("https://developer.r-project.org/Logo/Rlogo-3.png")

# Create morphing animation
both <- image_scale(c(oldlogo, logo), "400")
image_average(image_crop(both))
image_animate(image_morph(both, 10))
# Basic compositions
image_composite(banana, image_scale(logo, "300"))

# Break down and combine frames
front <- image_scale(banana, "300")
background <- image_background(image_scale(logo, "400"), 'white')
frames <- image_apply(front, function(x){image_composite(background, x, offset = "+70+30")})
image_animate(frames, fps = 10)
}
\references{
Magick++ Image STL: \url{https://www.imagemagick.org/Magick++/STL.html}
}
\seealso{
Other image: \code{\link{transformations}}
}
