% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maic.R
\name{maicWeight}
\alias{maicWeight}
\title{Calculate MAIC weights}
\usage{
maicWeight(x, opt = TRUE, keep.x = TRUE, ...)
}
\arguments{
\item{x}{Either a \code{maic.input} object or a MAIC input matrix}

\item{opt}{return the optim object as attribute}

\item{keep.x}{return the input matrix as an attribute}

\item{...}{Optional arguments to \code{\link{optim}}}
}
\value{
A numeric vector of weights corresponding to the rows in the input
        matrix
}
\description{
This function calculates the weights to apply to records for 
Matching-Adjusted Indirect Comparison (MAIC), from either a raw input
matrix or a \code{maic.input} object
}
\examples{
target <- c("Air.Flow" = 60,
           "Water.Temp" = 21,
           "Prop.Acid.Conc.LT.90" = 0.7,
           "min.air.flow" = 55)

stackloss$match.conc.lt.90 <- 
  ifelse(stackloss$Acid.Conc. < 90, 1, 0)

dict <- data.frame(
  "match.id" = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"),
  "target.variable" = 
    c("Air.Flow", "Water.Temp",
      "Prop.Acid.Conc.LT.90", "min.air.flow"),
  "index.variable" = 
    c("Air.Flow", "Water.Temp",
      "match.conc.lt.90", "Air.Flow"),
  "match.type" = 
    c("mean", "mean", "proportion", "min"),
  stringsAsFactors = FALSE)

ipmat <- createMAICInput(
  index = stackloss,
  target = target,
  dictionary = dict,
  matching.variables = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"))

wts <- maicWeight(ipmat)

rcv <- reportCovariates(
  stackloss, target, dict, 
  matching.variables = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"),
  wts)
}
