% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maic.R
\name{reportCovariates}
\alias{reportCovariates}
\title{Calculate the rebalanced covariates}
\usage{
reportCovariates(
  index,
  target,
  dictionary,
  matching.variables,
  weights,
  tidy = TRUE,
  var.method = c("ML", "unbiased")
)
}
\arguments{
\item{index}{A matrix or data.frame containing patient-level data}

\item{target}{A list containing target summary data}

\item{dictionary}{A data frame containing the columns "match.id",
"target.variable", "index.variable" and "match.type"}

\item{matching.variables}{A character vector indicating the match.id to use}

\item{weights}{A numeric vector with weights corresponding to the index 
data rows}

\item{tidy}{A boolean - return as a data frame (otherwise list)}

\item{var.method}{Estimator type passed through to \code{\link{wtd.var}}.
Defaults to \code{ML}, as Bessel's correction not used in
weights generation.}
}
\value{
An object of class \code{maic.covariates}
}
\description{
This function calculates the raw, target and achieved covariates given
a set of weights.
Note that for mean values, bootstrapped standard errors are used and so
downstream values (such as p-values for difference) may differ from run
to run if the random number stream is not consistent
}
\examples{
target <- c("Air.Flow" = 60,
           "Water.Temp" = 21,
           "Prop.Acid.Conc.LT.90" = 0.7,
           "min.air.flow" = 55)

stackloss$match.conc.lt.90 <- 
  ifelse(stackloss$Acid.Conc. < 90, 1, 0)

dict <- data.frame(
  "match.id" = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"),
  "target.variable" = 
    c("Air.Flow", "Water.Temp",
      "Prop.Acid.Conc.LT.90", "min.air.flow"),
  "index.variable" = 
    c("Air.Flow", "Water.Temp",
      "match.conc.lt.90", "Air.Flow"),
  "match.type" = 
    c("mean", "mean", "proportion", "min"),
  stringsAsFactors = FALSE)

ipmat <- createMAICInput(
  index = stackloss,
  target = target,
  dictionary = dict,
  matching.variables = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"))

wts <- maicWeight(ipmat)

rcv <- reportCovariates(
  stackloss, target, dict, 
  matching.variables = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"),
  wts)
}
