% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{compile_stan}
\alias{compile_stan}
\title{Compile stan-model}
\usage{
compile_stan(save = FALSE, permanent = FALSE, path = NULL)
}
\arguments{
\item{save}{Whether to save stan-file to location in package or not, defaults to \code{FALSE}. Must be in interactive session to save the object to a file.}

\item{permanent}{If \code{TRUE}, the file is stored in the package directory. If \code{FALSE} (default),
the file is saved in \code{tempdir()}.}

\item{path}{Only used if file cannot be saved in the package folder. This is a path to a folder where the file
is stored, do not specify a name for the file! (It will be called \code{"full_file.rds"}, and should not be changed.)
This argument makes the \code{permanent} argument being ignored.}
}
\value{
Returns the stan-model invisibly.
}
\description{
Function that compiles the stan-code for inference that is included in the model.
The compiled version is stored in a .rds-file, which is by default stored in tempdir().
Can also be stored in the package (permanent = TRUE), or in a custom directory.
In the latter case, this custom directory must be specified every time
\link[makemyprior]{inference_stan} is called.
This will also be done by \link[makemyprior]{inference_stan}, but this way can save some time if it is not
already pre-compiled.
}
\details{
Note that you will get a message saying something about integer division. The PC priors on variance proportions
are represented by splines, and to evaluate them in Stan we look up values, and use integer division for this. This does
not cause problems.
}
\examples{

if (interactive() && requireNamespace("rstan")){
  compile_stan(save = TRUE) # saving in tempdir()
}

}
