# WARNING - Generated by {fusen} from dev/dereplicate-spectra.Rmd: do not edit by hand

cosine_similarity <- matrix(
  c(
    1, 0.79, 0.77, 0.99, 0.98, 0.98,
    0.79, 1, 0.98, 0.79, 0.8, 0.8,
    0.77, 0.98, 1, 0.77, 0.77, 0.77,
    0.99, 0.79, 0.77, 1, 1, 0.99,
    0.98, 0.8, 0.77, 1, 1, 1,
    0.98, 0.8, 0.77, 0.99, 1, 1
  ),
  nrow = 6,
  dimnames = list(
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    ),
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    )
  )
)
cosine_similarity_with_fof <- matrix(
  c(
    1, 0.994, 0.995, 0.995, 0.993, 0.994, 0.91, 0.996,
    0.994, 1, 0.997, 0.995, 0.995, 0.994, 0.91, 0.995,
    0.995, 0.997, 1, 0.995, 0.995, 0.997, 0.913, 0.997,
    0.995, 0.995, 0.995, 1, 0.994, 0.993, 0.907, 0.998,
    0.993, 0.995, 0.995, 0.994, 1, 0.995, 0.915, 0.994,
    0.994, 0.994, 0.997, 0.993, 0.995, 1, 0.922, 0.996,
    0.91, 0.91, 0.913, 0.907, 0.915, 0.922, 1, 0.907,
    0.996, 0.995, 0.997, 0.998, 0.994, 0.996, 0.907, 1
  ),
  nrow = 8,
  dimnames = list(
    c("1_A", "2_B", "3_C", "4_D", "5_E", "6_F", "7_G", "8_H"),
    c("1_A", "2_B", "3_C", "4_D", "5_E", "6_F", "7_G", "8_H")
  )
)
test_that("delineate_with_similarity works", {
  expect_equal(
    nrow(delineate_with_similarity(cosine_similarity, 0.92)), 6
  )
  expect_equal(
    delineate_with_similarity(cosine_similarity, 0.92)$membership,
    c(1, 2, 2, 1, 1, 1)
  )
  expect_equal(
    delineate_with_similarity(
      cosine_similarity_with_fof, 0.92
    )$membership,
    rep(1, times = 8)
  )
})
test_that("delineate_with_similarity fails with wrong input", {
  expect_error(
    delineate_with_similarity(cosine_similarity[, -1], 0.92),
    "not square"
  )
  expect_error(
    delineate_with_similarity(unname(cosine_similarity), 0.92),
    "no rownames or colnames."
  )
  expect_error(
    delineate_with_similarity(cosine_similarity, TRUE),
    "not a numeric"
  )
})
