# WARNING - Generated by {fusen} from dev/dereplicate-spectra.Rmd: do not edit by hand

clusters <- readRDS(system.file("clusters_tibble.RDS", package = "maldipickr"))
set.seed(104)
metadata <- dplyr::transmute(clusters, name = name, OD600 = runif(n = nrow(clusters))) %>%
  dplyr::mutate(
    well = gsub(".*[A-Z]([0-9]{1,2}$)", "\\1", name) %>%
      strtoi(),
    is_edge = is_well_on_edge(
      well_number = well, plate_layout = 96, edges = "right"
    ),
    picked_before = grepl("_F", name)
  )
altered_metadata <- dplyr::mutate(metadata, name = gsub("species", "", name))
test_that("pick_spectra works", {
  expect_true(
    identical(
      pick_spectra(clusters)$is_reference,
      pick_spectra(clusters)$to_pick
    )
  )
  expect_equal(
    pick_spectra(clusters, metadata, "OD600")$to_pick,
    c(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE)
  )
  expect_equal(
    pick_spectra(clusters, metadata, "OD600",
      is_descending_order = FALSE
    )$to_pick,
    c(FALSE, FALSE, TRUE, FALSE, FALSE, TRUE)
  )
  expect_equal(
    pick_spectra(clusters, metadata, "OD600",
      soft_mask_column = "is_edge"
    )$to_pick,
    c(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE)
  )
  expect_equal(
    pick_spectra(clusters, metadata, "OD600",
      hard_mask_column = "picked_before"
    )$to_pick,
    c(FALSE, TRUE, FALSE, FALSE, FALSE, FALSE)
  )
  expect_equal(
    pick_spectra(clusters, is_sorted = TRUE)$to_pick,
    c(FALSE, FALSE, TRUE, FALSE, TRUE, FALSE)
  )
  expect_message(
    out <- pick_spectra(clusters, metadata, "OD600", is_sorted = TRUE),
    "The 'is_sorted' flag is set to TRUE, while a metadata table is provided."
  )
  expect_equal(
    out$to_pick,
    c(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE)
  )
})
test_that("pick_spectra fails without metadata and column", {
  expect_error(
    pick_spectra(clusters[, -1]),
    "lacks one of the following columns"
  )
  expect_error(
    pick_spectra(clusters[, -6]),
    "No additional metadata are provided"
  )
  expect_error(
    pick_spectra(clusters, metadata),
    "Additional metadata"
  )
  expect_error(
    pick_spectra(clusters, altered_metadata, "OD600"),
    "The spectra names in the metadata"
  )
  expect_error(
    pick_spectra(clusters, metadata, "CRITERIA_NOT_IN_TIBBLE"),
    "The 'criteria_column' is not present in the merged tibble."
  )
  expect_error(
    pick_spectra(clusters, metadata, "OD600",
      soft_mask_column = "is_egde" # Typo in soft_mask_column
    ),
    "The 'soft_mask_column' is not present in the merged tibble."
  )
  expect_error(
    pick_spectra(clusters, metadata, "OD600",
      hard_mask_column = "NOT_IN_TIBBLE"
    ),
    "The 'hard_mask_column' is not present in the merged tibble."
  )
  expect_error(
    pick_spectra(clusters, hard_mask_column = "picked_before"),
    "Masking column"
  )
})
