# WARNING - Generated by {fusen} from dev/flat_utils.Rmd: do not edit by hand

directory_biotyper_spectra <- system.file("toy-species-spectra", package = "maldipickr")
spectra_list_test <- import_biotyper_spectra(directory_biotyper_spectra)[1:2]
test_that("get_spectra_names works", {
  expect_no_warning(
    out <- get_spectra_names(spectra_list_test)
  )
  expect_equal(
    dim(out), c(2, 4)
  )
  expect_equal(
    out$sanitized_name, c("species1_G2", "species2_E11")
  )
})
test_that("get_spectra_names warns when duplicate", {
  expect_warning(
    out <- get_spectra_names(spectra_list_test[c(1,1)]),
    "Non-unique values in spectra names!"
  )
  expect_equal(
    dim(out), c(2, 4)
  )
  expect_equal(
    out$sanitized_name, c("species1_G2", "species1_G2")
  )
})
test_that("get_spectra_names fails on empty spectra", {
  expect_error(
    get_spectra_names(c(MALDIquant::createMassSpectrum(0, 0))),
    "Empty spectra detected!"
  )
})
