/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAssignment
extends TestCase {
    private Variable[] vars;

    public TestAssignment(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.vars = new Variable[]{new Variable(2), new Variable(2)};
    }

    public void testSimple() {
        Assignment assn = new Assignment(this.vars, new int[]{1, 0});
        TestAssignment.assertEquals((int)1, (int)assn.get(this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(this.vars[1]));
        TestAssignment.assertEquals((Object)new Integer(0), (Object)assn.getObject(this.vars[1]));
    }

    public void testScale() {
        Assignment assn = new Assignment(this.vars, new int[]{1, 0});
        assn.addRow(this.vars, new int[]{1, 0});
        assn.addRow(this.vars, new int[]{1, 1});
        Assignment assn2 = new Assignment(this.vars, new int[]{1, 0});
        assn.normalize();
        TestAssignment.assertEquals((double)0.666666, (double)assn.value(assn2), (double)1.0E-5);
    }

    public void testScaleMarginalize() {
        Assignment assn = new Assignment(this.vars, new int[]{1, 0});
        assn.addRow(this.vars, new int[]{1, 0});
        assn.addRow(this.vars, new int[]{1, 1});
        assn.normalize();
        Factor mrg = assn.marginalize(this.vars[1]);
        Assignment assn2 = new Assignment(this.vars[1], 0);
        TestAssignment.assertEquals((double)0.666666, (double)mrg.value(assn2), (double)1.0E-5);
    }

    public void testSerialization() throws IOException, ClassNotFoundException {
        Assignment assn = new Assignment(this.vars, new int[]{1, 0});
        Assignment assn2 = (Assignment)TestSerializable.cloneViaSerialization(assn);
        TestAssignment.assertEquals((int)2, (int)assn2.numVariables());
        TestAssignment.assertEquals((int)1, (int)assn2.numRows());
        TestAssignment.assertEquals((int)1, (int)assn.get(this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(this.vars[1]));
    }

    public void testMarginalize() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        Assignment assn2 = (Assignment)assn.marginalize(this.vars[0]);
        TestAssignment.assertEquals((int)2, (int)assn2.numRows());
        TestAssignment.assertEquals((int)1, (int)assn2.size());
        TestAssignment.assertEquals((Object)this.vars[0], (Object)assn2.getVariable(0));
        TestAssignment.assertEquals((int)1, (int)assn.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)1, (int)assn.get(1, this.vars[0]));
    }

    public void testMarginalizeOut() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        Assignment assn2 = (Assignment)assn.marginalizeOut(this.vars[1]);
        TestAssignment.assertEquals((int)2, (int)assn2.numRows());
        TestAssignment.assertEquals((int)1, (int)assn2.size());
        TestAssignment.assertEquals((Object)this.vars[0], (Object)assn2.getVariable(0));
        TestAssignment.assertEquals((int)1, (int)assn.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)1, (int)assn.get(1, this.vars[0]));
    }

    public void testUnion() {
        Assignment assn1 = new Assignment();
        assn1.addRow(new Variable[]{this.vars[0]}, new int[]{1});
        Assignment assn2 = new Assignment();
        assn2.addRow(new Variable[]{this.vars[1]}, new int[]{0});
        Assignment assn3 = Assignment.union(assn1, assn2);
        TestAssignment.assertEquals((int)1, (int)assn3.numRows());
        TestAssignment.assertEquals((int)2, (int)assn3.numVariables());
        TestAssignment.assertEquals((int)1, (int)assn3.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn3.get(0, this.vars[1]));
    }

    public void testMultiRow() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        TestAssignment.assertEquals((int)2, (int)assn.numRows());
        TestAssignment.assertEquals((int)1, (int)assn.get(0, this.vars[1]));
        TestAssignment.assertEquals((int)0, (int)assn.get(1, this.vars[1]));
        try {
            assn.get(this.vars[1]);
            TestAssignment.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetRow() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        TestAssignment.assertEquals((int)1, (int)assn.get(0, this.vars[0]));
        assn.setRow(0, new int[]{0, 0});
        TestAssignment.assertEquals((int)2, (int)assn.numRows());
        TestAssignment.assertEquals((int)0, (int)assn.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(0, this.vars[1]));
        TestAssignment.assertEquals((int)1, (int)assn.get(1, this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(1, this.vars[1]));
    }

    public void testSetRowFromAssn() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        TestAssignment.assertEquals((int)1, (int)assn.get(0, this.vars[0]));
        Assignment assn2 = new Assignment();
        assn2.addRow(this.vars, new int[]{0, 0});
        assn.setRow(0, assn2);
        TestAssignment.assertEquals((int)2, (int)assn.numRows());
        TestAssignment.assertEquals((int)0, (int)assn.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(0, this.vars[1]));
        TestAssignment.assertEquals((int)1, (int)assn.get(1, this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(1, this.vars[1]));
    }

    public void testSetValue() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.setValue(this.vars[0], 0);
        TestAssignment.assertEquals((int)1, (int)assn.numRows());
        TestAssignment.assertEquals((int)0, (int)assn.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)1, (int)assn.get(0, this.vars[1]));
    }

    public void testSetValueDup() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        Assignment dup = (Assignment)assn.duplicate();
        dup.setValue(this.vars[0], 0);
        TestAssignment.assertEquals((int)1, (int)dup.numRows());
        TestAssignment.assertEquals((int)0, (int)dup.get(0, this.vars[0]));
        TestAssignment.assertEquals((int)1, (int)dup.get(0, this.vars[1]));
    }

    public void testSetValueExpand() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{0, 0});
        Variable v3 = new Variable(2);
        assn.setValue(v3, 1);
        TestAssignment.assertEquals((int)3, (int)assn.size());
        TestAssignment.assertEquals((int)0, (int)assn.get(this.vars[0]));
        TestAssignment.assertEquals((int)0, (int)assn.get(this.vars[1]));
        TestAssignment.assertEquals((int)1, (int)assn.get(v3));
    }

    public void testAsTable() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        assn.addRow(this.vars, new int[]{1, 0});
        AbstractTableFactor tbl = assn.asTable();
        TableFactor exp = new TableFactor(this.vars, new double[]{0.0, 0.0, 2.0, 1.0});
        TestAssignment.assertTrue((boolean)exp.almostEquals(tbl));
    }

    public void testAddRowMixed() {
        Assignment assn = new Assignment();
        assn.addRow(this.vars, new int[]{1, 1});
        assn.addRow(this.vars, new int[]{1, 0});
        Assignment assn2 = new Assignment();
        assn2.addRow(new Variable[]{this.vars[1], this.vars[0]}, new int[]{0, 1});
        assn.addRow(assn2);
        AbstractTableFactor tbl = assn.asTable();
        TableFactor exp = new TableFactor(this.vars, new double[]{0.0, 0.0, 2.0, 1.0});
        TestAssignment.assertTrue((boolean)exp.almostEquals(tbl));
    }

    public static Test suite() {
        return new TestSuite(TestAssignment.class);
    }

    public static void main(String[] args) throws Exception {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestAssignment(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestAssignment.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

