% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/scaling_functions.R
\name{vanilla}
\alias{vanilla}
\title{Vanilla Scaling by Gabel & Huber}
\usage{
vanilla(data, vars = grep("per\\\\d{3}$", names(data), value = TRUE),
  invert = FALSE)
}
\arguments{
\item{data}{a dataframe or matrix}

\item{vars}{variable names that should be used for the scaling (usually the variables per101,per102,...)}

\item{invert}{invert scores (to change the direction of the dimension to facilitate comparison with other indices) (default is FALSE)}
}
\description{
Computes scores based on the Vanilla method suggested by Gabel & Huber.
A factor analysis identifies the dominant dimension in the data.
Factor scores using the regression method are then considered as party positions on this dominant dimension.
}
\references{
Gabel, M. J., & Huber, J. D. (2000). Putting Parties in Their Place: Inferring Party Left-Right Ideological Positions from Party Manifestos Data. American Journal of Political Science, 44(1), 94-103.
}

