% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{mwSlider}
\alias{mwSlider}
\title{Add a Slider to a manipulateWidget gadget}
\usage{
mwSlider(min, max, value, label = NULL, ..., .display = TRUE)
}
\arguments{
\item{min}{The minimum value that can be selected.}

\item{max}{The maximum value that can be selected.}

\item{value}{Initial value of the slider  A numeric vector of length one will create a
regular slider; a numeric vector of length two will create a double-ended
range slider}

\item{label}{Display label for the control. If \code{NULL}, the name of the corresponding
variable is used.}

\item{...}{Other arguments passed to function\code{\link[shiny]{sliderInput}}}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the input control should be shown/hidden.}
}
\value{
A function that will generate the input control.
}
\description{
Add a Slider to a manipulateWidget gadget
}
\examples{

if (require(plotly)) {

  myWidget <- manipulateWidget(
    plot_ly(data.frame(x = 1:n, y = rnorm(n)), x=~x, y=~y, type = "scatter", mode = "markers"),
    n = mwSlider(1, 100, 10, label = "Number of values")
  )

  Sys.sleep(0.5)

  # Create a double ended slider to choose a range instead of a single value
  mydata <- data.frame(x = 1:100, y = rnorm(100))

  manipulateWidget(
    plot_ly(mydata[n[1]:n[2], ], x=~x, y=~y, type = "scatter", mode = "markers"),
    n = mwSlider(1, 100, c(1, 10), label = "Number of values")
  )

}

}
\seealso{
Other controls: 
\code{\link{mwCheckboxGroup}()},
\code{\link{mwCheckbox}()},
\code{\link{mwDateRange}()},
\code{\link{mwDate}()},
\code{\link{mwGroup}()},
\code{\link{mwNumeric}()},
\code{\link{mwPassword}()},
\code{\link{mwRadio}()},
\code{\link{mwSelectize}()},
\code{\link{mwSelect}()},
\code{\link{mwSharedValue}()},
\code{\link{mwText}()}
}
\concept{controls}
