% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{network_map}
\alias{network_map}
\title{Plot geographical networks}
\usage{
network_map(object, date, theme = "light")
}
\arguments{
\item{object}{Unimodal geographical network. Needs to contain ISO3c country
IDs.}

\item{date}{String date at which the network snapshot was taken
(e.g. "2010-01-01").
Used by \code{{cshapes}} to plot the correct map.
Date can be between 1886 and 2021.}

\item{theme}{Theme you would like to use to plot the graph.
Available themes are "light", "dark", and "earth".}
}
\value{
A map of a country level geographical network.
}
\description{
Creates a plot of the a unimodal geographical network.
}
\examples{
\donttest{
# Plot a network of environmental agreements signed in 2010
# extracted from {manyenviron} using data from ECOLEX.
# Light theme
membership <- migraph::as_igraph(data.frame(
  from = c("ETH", "ETH", "ETH", "ETH", "UKR", "UKR",
           "MOZ", "MOZ", "JPN", "JPN"),
  to = c("GNQ", "KEN", "TZA", "RWA", "CHN", "POL",
         "COL", "NZL", "MNE", "LKA")))
network_map(membership, date = "2010-01-01", theme = "light") +
  ggplot2::labs(title = "Sample of International Environmental Treaties 2010",
                 subtitle = "Ecolex data",
                 caption = "Created with love by {}")
# Earth theme
network_map(membership, date = "2010-01-01", theme = "earth") +
  ggplot2::labs(title = "International Environmental Treaties 2010",
                 subtitle = "Ecolex data",
                 caption = "Created with love by {}")
}
}
