% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_indirect_list.R
\name{indirect_effects_from_list}
\alias{indirect_effects_from_list}
\title{Coefficient Table of an 'indirect_list' Class
Object}
\usage{
indirect_effects_from_list(object, add_sig = TRUE)
}
\arguments{
\item{object}{The output of
\code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.}

\item{add_sig}{Whether a column
of significance test results
will be added. Default is \code{TRUE}.}
}
\value{
A data frame with the
indirect effect estimates and
confidence intervals (if available).
It also has A string column, \code{"Sig"},
for #' significant test results
if \code{add_sig} is \code{TRUE} and bootstrap
confidence intervals are available.
}
\description{
Create a coefficient table
for the point estimates and
confidence intervals (if available)
in the
output of \code{\link[=many_indirect_effects]{many_indirect_effects()}}.
}
\examples{

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)

# All indirect paths from x to y
paths <- all_indirect_paths(fit,
                           x = "x",
                           y = "y")
paths

# Indirect effect estimates
out <- many_indirect_effects(paths,
                             fit = fit)
out

# Create a data frame of the indirect effect estimates

out_df <- indirect_effects_from_list(out)
out_df


}
\seealso{
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
