% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_heterogeneity.R
\name{measure_heterogeneity}
\alias{measure_heterogeneity}
\alias{net_richness}
\alias{node_richness}
\alias{net_diversity}
\alias{node_diversity}
\alias{net_heterophily}
\alias{node_heterophily}
\alias{net_homophily}
\alias{node_homophily}
\alias{net_assortativity}
\alias{net_spatial}
\title{Measures of network diversity}
\usage{
net_richness(.data, attribute)

node_richness(.data, attribute)

net_diversity(
  .data,
  attribute,
  method = c("blau", "teachman", "variation", "gini")
)

node_diversity(
  .data,
  attribute,
  method = c("blau", "teachman", "variation", "gini")
)

net_heterophily(.data, attribute)

node_heterophily(.data, attribute)

net_homophily(.data, attribute, method = c("ie", "ei", "yule", "geary"))

node_homophily(.data, attribute, method = c("ie", "ei", "yule", "geary"))

net_assortativity(.data)

net_spatial(.data, attribute)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{attribute}{Name of a nodal attribute or membership vector
to use as categories for the diversity measure.}

\item{method}{Which method to use for \code{net_diversity()}.
Either "blau" (Blau's index) or "teachman" (Teachman's index) for
categorical attributes, or "variation" (coefficient of variation)
or "gini" (Gini coefficient) for numeric attributes.
Default is "blau".
If an incompatible method is chosen for the attribute type,
a suitable alternative will be used instead with a message.}
}
\description{
These functions offer ways to measure the heterogeneity of an attribute
across a network, within groups of a network, or the distribution of ties
across this attribute:
\itemize{
\item \code{net_richness()} measures the number of unique categories
in a network attribute.
\item \code{node_richness()} measures the number of unique categories
of an attribute to which each node is connected.
\item \code{net_diversity()} measures the heterogeneity of ties across a network.
\item \code{node_diversity()} measures the heterogeneity of each node's
local neighbourhood.
\item \code{net_heterophily()} measures how embedded nodes in the network
are within groups of nodes with the same attribute.
\item \code{node_heterophily()} measures each node's embeddedness within groups
of nodes with the same attribute.
\item \code{net_assortativity()} measures the degree assortativity in a network.
\item \code{net_spatial()} measures the spatial association/autocorrelation
(global Moran's I) in a network.
}
}
\section{Richness}{

Richness is a simple count of the number of different categories
present for a given attribute.
}

\section{Diversity}{

Blau's index (1977) uses a formula known also in other disciplines
by other names
(Gini-Simpson Index, Gini impurity, Gini's diversity index,
Gibbs-Martin index, and probability of interspecific encounter (PIE)):
\deqn{1 - \sum\limits_{i = 1}^k {p_i^2 }}
where \eqn{p_i} is the proportion of group members in \eqn{i}th category
and \eqn{k} is the number of categories for an attribute of interest.
This index can be interpreted as the probability that two members
randomly selected from a group would be from different categories.
This index finds its minimum value (0) when there is no variety,
i.e. when all individuals are classified in the same category.
The maximum value depends on the number of categories and
whether nodes can be evenly distributed across categories.

Teachman's index (1980) is based on information theory
and is calculated as:
\deqn{- \sum\limits_{i = 1}^k {p_i \log(p_i)}}
where \eqn{p_i} is the proportion of group members in \eqn{i}th category
and \eqn{k} is the number of categories for an attribute of interest.
This index finds its minimum value (0) when there is no variety,
i.e. when all individuals are classified in the same category.
The maximum value depends on the number of categories and
whether nodes can be evenly distributed across categories.
It thus shares similar properties to Blau's index,
but includes also a notion of richness that tends to give more weight to
rare categories and thus tends to highlight imbalances more.

The coefficient of variation (CV) is a standardised measure of dispersion
of a probability distribution or frequency distribution.
It is defined as the ratio of the standard deviation \eqn{\sigma}
to the mean \eqn{\mu}:
\deqn{CV = \frac{\sigma}{\mu}}
It is often expressed as a percentage.
The CV is useful because the standard deviation of data must always be understood
in the context of the mean of the data.
The CV is particularly useful when comparing the degree of variation
from one data series to another,
even if the means are drastically different from each other.

The Gini coefficient is a measure of statistical dispersion
that is intended to represent the income or wealth distribution
of a nation's residents,
and is commonly used as a measure of inequality.
It is defined as a ratio with values between 0 and 1,
where 0 corresponds with perfect equality
(everyone has the same income) and 1 corresponds with perfect inequality
(one person has all the income, and everyone else has zero income).
The Gini coefficient can be calculated from the Lorenz curve,
which plots the proportion of the total income of the population
that is cumulatively earned by the bottom x\% of the population.
The Gini coefficient is defined as the area between the line of equality
and the Lorenz curve,
divided by the total area under the line of equality.
}

\section{Homophily}{

Given a partition of a network into a number of mutually exclusive groups then
The E-I index is the number of ties between (or \emph{external}) nodes
grouped in some mutually exclusive categories
minus the number of ties within (or \emph{internal}) these groups
divided by the total number of ties.
This value can range from 1 to -1,
where 1 indicates ties only between categories/groups and -1 ties only within categories/groups.
}

\examples{
net_richness(ison_networkers)
node_richness(ison_networkers, "Discipline")
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
net_diversity(marvel_friends, "Gender")
net_diversity(marvel_friends, "Appearances")
node_diversity(marvel_friends, "Gender")
node_diversity(marvel_friends, "Attractive")
net_heterophily(marvel_friends, "Gender")
net_heterophily(marvel_friends, "Attractive")
node_heterophily(marvel_friends, "Gender")
node_heterophily(marvel_friends, "Attractive")
net_homophily(marvel_friends, "Gender")
net_assortativity(ison_networkers)
net_spatial(ison_lawfirm, "age")
}
\references{
\subsection{On richness}{

Magurran, Anne E. 1988.
\emph{Ecological Diversity and Its Measurement}.
Princeton: Princeton University Press.
\doi{10.1007/978-94-015-7358-0}
}

\subsection{On diversity}{

Blau, Peter M. 1977.
\emph{Inequality and heterogeneity}.
New York: Free Press.

Teachman, Jay D. 1980.
Analysis of population diversity: Measures of qualitative variation.
\emph{Sociological Methods & Research}, 8:341-362.
\doi{10.1177/004912418000800305}

Page, Scott E. 2010.
\emph{Diversity and Complexity}.
Princeton: Princeton University Press.
\doi{10.1515/9781400835140}
}

\subsection{On heterophily}{

Krackhardt, David, and Robert N. Stern. 1988.
Informal networks and organizational crises: an experimental simulation.
\emph{Social Psychology Quarterly} 51(2): 123-140.
\doi{10.2307/2786835}

McPherson, Miller, Lynn Smith-Lovin, and James M. Cook. 2001.
"Birds of a Feather: Homophily in Social Networks".
\emph{Annual Review of Sociology}, 27(1): 415-444.
\doi{10.1146/annurev.soc.27.1.415}
}

\subsection{On assortativity}{

Newman, Mark E.J. 2002.
"Assortative mixing in networks".
\emph{Physical Review Letters}, 89(20): 208701.
\doi{10.1103/physrevlett.89.208701}
}

\subsection{On spatial autocorrelation}{

Moran, Patrick Alfred Pierce. 1950.
"Notes on continuous stochastic phenomena".
\emph{Biometrika} 37(1): 17-23.
\doi{10.2307/2332142}
}
}
\seealso{
Other measures: 
\code{\link{measure_attributes}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
