% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_getTiles.R
\name{esp_getTiles}
\alias{esp_getTiles}
\title{Get Tiles from Public Administrations of Spanish.}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.2.0}.
}
\usage{
esp_getTiles(
  x,
  type = "IDErioja",
  zoom = NULL,
  crop = TRUE,
  res = 512,
  bbox_expand = 0.05,
  transparent = TRUE,
  mask = FALSE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{An \code{sf} object.}

\item{type}{Name of the provider. See \link{leaflet.providersESP.df}.}

\item{zoom}{Zoom level. If \code{NULL}, it is determined automatically.
Only valid for WMTS.}

\item{crop}{\code{TRUE} if results should be cropped to the specified \code{x} extent,
\code{FALSE} otherwise. If \code{x} is an \code{sf} object with one \code{POINT}, crop is set
to \code{FALSE}.}

\item{res}{Resolution (in pixels) of the final tile. Only valid for WMS.}

\item{bbox_expand}{A numeric value that indicates the expansion percentage
of the bounding box of \code{x}.}

\item{transparent}{Logical. Provides transparent background, if supported.
Depends on the selected provider on \code{type}.}

\item{mask}{\code{TRUE} if the result should be masked to \code{x}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with \code{options(mapSpain_cache_dir = "path/to/dir")}.
See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{RasterBrick} is returned, with 3 (RGB) or 4 (RGBA) layers, depending on
the provider.
.
}
\description{
Get static map tiles based on a spatial object. Maps can be fetched from
various open map servers.

This function is a implementation of the javascript plugin
\url{https://dieghernan.github.io/leaflet-providersESP/} \strong{v1.2.0}.
}
\details{
Zoom levels are described on the OpenStreetMap wiki:
\url{https://wiki.openstreetmap.org/wiki/Zoom_levels}.

Results of \code{esp_getTiles} could be plotted using \code{\link[raster:plotRGB]{raster::plotRGB()}} or
\code{\link[cartography:tilesLayer]{cartography::tilesLayer()}}

For a complete list of providers see \link{leaflet.providersESP.df}.

Most WMS/WMTS providers provide tiles on EPSG:3857. In case that the tile
looks deformed, try projecting first \code{x}:

\code{x <- sf::st_transform(x,3857)}

Tiles are cached under the path \verb{cache_dir/[type]}.
}
\seealso{
\link{leaflet.providersESP.df}, \code{\link[=addProviderEspTiles]{addProviderEspTiles()}}, \code{\link[raster:plotRGB]{raster::plotRGB()}},
\code{\link[cartography:getTiles]{cartography::getTiles()}}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{imagery}
