% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_erhmm.R
\name{erhmm}
\alias{erhmm}
\title{Create ERHMM}
\usage{
erhmm(
  size,
  shape,
  alpha = rep(1/length(shape), length(shape)),
  rate = rep(1, length(shape)),
  P = matrix(1/length(shape), length(shape), length(shape))
)
}
\arguments{
\item{size}{An integer of the number of phases}

\item{shape}{A vector of shape parameters}

\item{alpha}{A vector of initial probability (alpha)}

\item{rate}{A vector of rate parameters}

\item{P}{A matrix of transition probabilities}
}
\value{
An instance of ERHMM
}
\description{
Create an instance of ERHMM
}
\note{
If shape is given, shape is used even though size is set.
}
