% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAPI_Tails.R
\name{MAPI_Tails}
\alias{MAPI_Tails}
\title{Function MAPI_Tails}
\usage{
MAPI_Tails(resu, minQ = 0, alpha = 0.05)
}
\arguments{
\item{resu}{A spatial object of class 'sf' resulting from a MAPI analysis done using either
\code{\link{MAPI_RunAuto}} or \code{\link{MAPI_RunOnGrid}}.}

\item{minQ}{Threshold under which cells with the smallest sum-of-weights centile (range 1 .. 100) are discarded (default value = 0). 
This parameter allows to discard cells for which the average value of the pairwise metric is computed 
using either a small number and/or only long-distance ellipses.}

\item{alpha}{Significance level (default=0.05)}
}
\value{
a spatial object of class 'sf' with the area and geometry of the polygons delineating the significant areas. 
   A column provides the tail for each polygon (upper or lower).
}
\description{
Determine significant continuous and discontinuous areas from the result 
  of a MAPI analysis when run with permutations.
}
\details{
When permutations are performed, in \code{\link{MAPI_RunOnGrid}} for each cell, the proportion of permuted values that are smaller or greater 
   than the observed value provides a lower-tailed (ltP) and upper-tailed (utP) test p-value.
   A false discovery rate (FDR) procedure (Benjamini and Yekutieli, 2001) is applied to account for multiple 
   testing (number of cells) under positive dependency conditions (spatial autocorrelation). An adjusted
   p-value is computed for each cell using the function \code{p.adjust} from the 'stats' package with the method 'BY'.
   The significance level at which FDR is controlled is set through the parameter alpha. For example, when alpha is
   set to 0.05, this means that 5\% of the cells detected as significant can be false positives.
   
   Significant cells belonging to the lower (or upper) tail that are spatially connected are aggregated 
   together to form the significant areas with the lowest (or greater) average values of the pairwise metric analysed.
}
\examples{
\dontrun{
data("metric")
data("samples")
# Run MAPI computation
resu <- MAPI_RunAuto(samples, metric, crs=3857, nbPermuts=1000)
# Discards the 10\% cells with the smallest sum-of-weights 
#    and aggregates adjacent cells belonging to the same tail 
#    at a 5\% significance level
tails <- MAPI_Tails(resu, minQ=10, alpha=0.05)
}

}
\references{
Benjamini, Y. and Yekutieli, D. (2001). The control of the false discovery rate in multiple testing under dependency. Annals of Statistics 29, 1165–1188.
}
