% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_traveltime.R
\name{traveltime}
\alias{traveltime}
\alias{calc_traveltime}
\title{Calculate accessibility statistics}
\usage{
calc_traveltime(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
single or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
}
\value{
A function that returns a tibble with a column for accessibility
statistics (in minutes).
}
\description{
Accessibility is the ease with which larger cities can be reached from a
certain location. This function allows to efficiently calculate accessibility
statistics (i.e. travel time to nearby major cities) for polygons. For each
polygon, the desired statistic/s (mean, median or sd) is/are returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{nelson_et_al}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_nelson_et_al(
    ranges = c("5k_10k", "100k_200k", "500k_1mio", "1mio_5mio")
  )) \%>\%
  calc_indicators(
    calc_traveltime(engine = "extract", stats = c("min", "max"))
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
