% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterer_farm.R
\name{local_hierarchical_clusterer}
\alias{local_hierarchical_clusterer}
\title{Create a dude to perform hierarchical clustering in a local context using the \link{hclust} package.}
\usage{
local_hierarchical_clusterer(method)
}
\arguments{
\item{method}{A string to pass to \link{hclust} to tell it what kind of clustering to do.}
}
\value{
A function that inputs a list of distance matrices and returns a list containing one vector per matrix, whose element names are data point names and whose values are cluster labels (within each patch).
}
\description{
Create a dude to perform hierarchical clustering in a local context using the \link{hclust} package.
}
\details{
This clusterer determines cutting heights for dendrograms by cutting them individually, just above the merge point with the longest unbroken gap until the next merge point.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x

dists = dist(data)

num_bins = 10
percent_overlap = 25

cover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

create_1D_mapper_object(data, dists, projx, cover, local_hierarchical_clusterer("mcquitty"))
}
