% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_leg_pl.R
\name{mf_legend_pl}
\alias{mf_legend_pl}
\title{Plot a legend for a proportional lines map}
\usage{
mf_legend_pl(
  pos = "left",
  val,
  lwd,
  col = "tomato4",
  title = "Legend Title",
  title_cex = 0.8,
  val_cex = 0.6,
  val_rnd = 0,
  frame = FALSE,
  bg,
  fg,
  cex = 1
)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top",
"topright", "right", "bottomright", "bottom", "bottomleft",
"left" or a vector of two coordinates in map units
(c(x, y)).}

\item{val}{vector of values (at least min and max).}

\item{lwd}{width of the largest line}

\item{col}{color of the lines}

\item{title}{title of the legend}

\item{title_cex}{size of the legend title}

\item{val_cex}{size of the values in the legend}

\item{val_rnd}{number of decimal places of the values in
the legend.}

\item{frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{bg}{background of the legend}

\item{fg}{foreground of the legend}

\item{cex}{size of the legend; 2 means two times bigger}
}
\value{
No return value, a legend is displayed.
}
\description{
This function plots a legend for proportional lines.
}
\examples{
plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
mf_legend_pl(lwd = 20, val = c(5, 10, 50, 100))
}
\keyword{internal}
