% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slideView.R
\docType{methods}
\name{slideView}
\alias{slideView}
\alias{slideView,RasterLayer,RasterLayer-method}
\alias{slideView,RasterStackBrick,RasterStackBrick-method}
\alias{slideView,character,character-method}
\alias{slideview}
\alias{slideview,ANY-method}
\title{slideView}
\usage{
\S4method{slideView}{RasterStackBrick,RasterStackBrick}(img1, img2, r = 3,
  g = 2, b = 1, na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("plainview.maxpixels"), ...)

\S4method{slideView}{RasterLayer,RasterLayer}(img1, img2,
  col.regions = mapviewGetOption("raster.palette")(256),
  na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("plainview.maxpixels"))

\S4method{slideView}{character,character}(img1, img2)

\S4method{slideview}{ANY}(...)
}
\arguments{
\item{img1}{a RasterStack/Brick, RasterLayer or path to a .png file}

\item{img2}{a RasterStack/Brick, RasterLayer or path to a .png file}

\item{r}{integer. Index of the Red channel, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel, between 1 and nlayers(x)}

\item{na.color}{the color to be used for NA pixels}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{...}{additional arguments passed on to repective functions.}

\item{col.regions}{color (palette).See \code{\link{levelplot}} for details.}

\item{color}{the color palette to be used for visualising RasterLayers}
}
\description{
Two images are overlaid and a slider is provided to interactively
compare the two images in a before-after like fashion. \code{img1} and
\code{img2} can either be two RasterLayers, two RasterBricks/Stacks or
two character strings. In the latter case it is assumed that these
point to .png images on the disk.

This is a modified implementation of http://bl.ocks.org/rfriberg/8327361
}
\details{
Compare two images trough interactive swiping overlay
}
\section{Methods (by class)}{
\itemize{
\item \code{img1 = RasterLayer,img2 = RasterLayer}: for RasterLayers

\item \code{img1 = character,img2 = character}: for png files

\item \code{ANY}: alias for ease of typing
}}
\examples{
### raster data ###
library(sp)
library(raster)

data(poppendorf)

stck1 <- subset(poppendorf, c(3, 4, 5))
stck2 <- subset(poppendorf, c(2, 3, 4))
slideView(stck1, stck2)

\dontrun{
### example taken from
### http://www.news.com.au/technology/environment/nasa-images-reveal-
### aral-sea-is-shrinking-before-our-eyes/story-e6frflp0-1227074133835

library(jpeg)
library(raster)

web_img2000 <- "http://cdn.newsapi.com.au/image/v1/68565a36c0fccb1bc43c09d96e8fb029"

jpg2000 <- readJPEG(readBin(web_img2000, "raw", 1e6))

# Convert imagedata to raster
rst_blue2000 <- raster(jpg2000[, , 1])
rst_green2000 <- raster(jpg2000[, , 2])
rst_red2000 <- raster(jpg2000[, , 3])

img2000 <- brick(rst_red2000, rst_green2000, rst_blue2000)

web_img2013 <- "http://cdn.newsapi.com.au/image/v1/5707499d769db4b8ec76e8df61933f2a"

jpg2013 <- readJPEG(readBin(web_img2013, "raw", 1e6))

# Convert imagedata to raster
rst_blue2013 <- raster(jpg2013[, , 1])
rst_green2013 <- raster(jpg2013[, , 2])
rst_red2013 <- raster(jpg2013[, , 3])

img2013 <- brick(rst_red2013, rst_green2013, rst_blue2013)

slideView(img2000, img2013)
}

}
\author{
Tim Appelhans

Stephan Woellauer
}

