% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.mtd.R
\name{march.mtd.construct}
\alias{march.mtd.construct}
\title{Construct a Mixture Transition Distribution (MTD) model.}
\usage{
march.mtd.construct(y, order, maxOrder = order, mtdg = FALSE,
  MCovar = 0, init = "best", deltaStop = 1e-04, llStop = 0.01,
  maxIter = 0)
}
\arguments{
\item{y}{the dataset (\code{\link{march.Dataset-class}}) from which to construct the model.}

\item{order}{the order of the constructed model.}

\item{maxOrder}{the maximum visible order among the set of Markovian models to compare.}

\item{mtdg}{flag indicating whether the constructed model should be a MTDg using a different transition matrix for each lag (value: \emph{TRUE} or \emph{FALSE}).}

\item{MCovar}{vector of the size Ncov indicating which covariables are used (0: no, 1:yes)}

\item{init}{the init method, to choose among \emph{best}, \emph{random} and \emph{weighted}.}

\item{deltaStop}{the delta below which the optimization phases of phi and Q stop.}

\item{llStop}{the ll increase below which the EM algorithm stop.}

\item{maxIter}{the maximal number of iterations of the optimisation algorithm (zero for no maximal number).}
}
\description{
A Mixture Transition Distribution model (\code{\link{march.Mtd-class}}) object of order \emph{order} is constructed
according to a given \code{\link{march.Dataset-class}} \emph{y}. The first \emph{maxOrder}-\emph{order}
elements of each sequence are truncated in order to return a model
which can be compared with other Markovian models of visible order maxOrder.
}
\examples{
# Build a 4th order MTD model from the pewee data set.
model <- march.mtd.construct(pewee,4)
print(model)

# Build a 3th order MTDg model from the pewee data set.
model <- march.mtd.construct(pewee,3,mtdg=TRUE)
print(model)

}
\seealso{
\code{\link{march.Mtd-class}}, \code{\link{march.Model-class}}, \code{\link{march.Dataset-class}}.
}
\author{
Ogier Maitre, Kevin Emery
}
