% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_effects.R,
%   R/marginal_effects_methods.R
\name{marginal_effects}
\alias{marginal_effects}
\alias{marginal_effects.default}
\alias{marginal_effects.margins}
\alias{marginal_effects.lm}
\alias{marginal_effects.glm}
\alias{marginal_effects.loess}
\title{Differentiate a Model Object with Respect to All Variables}
\usage{
marginal_effects(model, data, ...)

\method{marginal_effects}{default}(model, data = find_data(model,
  parent.frame()), type = c("response", "link"), eps = 1e-07, ...)

\method{marginal_effects}{margins}(model, data, ...)

\method{marginal_effects}{lm}(model, data = find_data(model, parent.frame()),
  type = c("response", "link"), eps = 1e-07, ...)

\method{marginal_effects}{glm}(model, data = find_data(model, parent.frame()),
  type = c("response", "link"), eps = 1e-07, ...)

\method{marginal_effects}{loess}(model, data = find_data(model,
  parent.frame()), type = c("response", "link"), eps = 1e-07, ...)
}
\arguments{
\item{model}{A model object, perhaps returned by \code{\link[stats]{lm}} or \code{\link[stats]{glm}}}

\item{data}{A data.frame over which to calculate marginal effects. This is optional, but may be required when the underlying modelling function sets \code{model = FALSE}.}

\item{\dots}{Arguments passed to methods, and onward to \code{\link{dydx}} methods.}

\item{type}{A character string indicating the type of marginal effects to estimate. Mostly relevant for non-linear models, where the reasonable options are \dQuote{response} (the default) or \dQuote{link} (i.e., on the scale of the linear predictor in a GLM).}

\item{eps}{A numeric value specifying the \dQuote{step} to use when calculating numerical derivatives. By default this is the smallest floating point value that can be represented on the present architecture.}
}
\value{
An data frame with number of rows equal to \code{nrow(data)}, where each row is an observation and each column is the marginal effect of a variable used in the model formula.
}
\description{
Extract marginal effects from a model object, conditional on data, using \code{\link{dydx}}.
}
\details{
This function extracts unit-specific marginal effects from an estimated model with respect to \emph{all} variables specified in \code{data} and returns a data.frame. (Note that this is not each \emph{coefficient}.) See \code{\link{dydx}} for computational details, or to extract the marginal effect for only one variable. Note that for factor and logical class variables, discrete changes in the outcome are reported rather than instantaneous marginal effects.

Methods are currently implemented for the following object classes:
\itemize{
  \item \dQuote{lm}, see \code{\link[stats]{lm}}
  \item \dQuote{glm}, see \code{\link[stats]{glm}}, \code{\link[MASS]{glm.nb}}
  \item \dQuote{loess}, see \code{\link[stats]{loess}}
}

A methods is also provided for the object classes \dQuote{margins} to return a simplified data frame from complete \dQuote{margins} objects.
}
\examples{
require("datasets")
x <- lm(mpg ~ cyl * hp + wt, data = mtcars)
marginal_effects(x)

# factor variables report discrete differences
x <- lm(mpg ~ factor(cyl) * factor(am), data = mtcars)
marginal_effects(x)

# get just marginal effects from "margins" object
require('datasets')
m <- margins(lm(mpg ~ hp, data = mtcars[1:10,]))
marginal_effects(m)
marginal_effects(m)

}
\seealso{
\code{\link{dydx}}, \code{\link{margins}}
}
\keyword{models}
