% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landings.R
\name{landings}
\alias{landings}
\title{Calculates the Landings per fished group}
\usage{
landings(land, groups, species.table = NULL, years)
}
\arguments{
\item{land}{A dataframe of commercial landings data with columns \code{YEAR},
\code{ID}, \code{SPECIES} and \code{CATCH}. \code{YEAR} indicates the year
the landing was recorded, \code{ID} is an area code indicating where the
landing was recorded, \code{SPECIES} is a numeric code indicating the
species landed, and \code{CATCH} is the corresponding landed weight.}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table with at least one column, where the column names
match the entries in \code{groups}, and the column entries are species codes
from \code{land} indicating which species are included that group.
\code{species.table} may also include columns for other species groups;
these will be ignored. If \code{group = "ALL"}, this table is not required.
Default is \code{species.table = NULL}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
  column \code{landings_group} for each entry in \code{groups}.

 If there is no data for a given year, the indicator value is set to 0.
}
\description{
This function calculates the commercial landings of predefined
 species groups for \eqn{j} areas and \eqn{i} years.
}
\details{
Calculates the Landings of predefined species groups.
}
\examples{
# Compile data
data(land)
data(species.table)

# Species of interest
landings.groups <- c("ALL", "CLUPEIDS.L", "FLATFISH.L", "GROUNDFISH.L")

# Calculate indicators
landings(land, groups = landings.groups, species.table = species.table, 
   years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.
}
\seealso{
Other fishing pressure indicators: \code{\link{allPressure}},
  \code{\link{fishingPressure}},
  \code{\link{meanTLLandings}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{fishing pressure indicators}
