% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframes.R
\name{complete_cases}
\alias{complete_cases}
\title{Complete cases}
\usage{
complete_cases(data, cols = NULL, invert = FALSE)
}
\arguments{
\item{data}{A data.frame}

\item{cols}{Colnames or numbers to remove \code{NA} values from; \code{NULL} (default)
will use all columns}

\item{invert}{Logical, if \code{TRUE} will return incomplete cases}
}
\value{
A \code{data.frame}
}
\description{
Return completed cases of a data.frame
}
\examples{
x <- data.frame(
  a = 1:5,
  b = c(1, NA, 3, 4, 5),
  c = c(1, NA, NA, 4, 5)
)

complete_cases(x)
complete_cases(x, invert = TRUE) # returns the incomplete rows
complete_cases(x, "a")
complete_cases(x, "b")
complete_cases(x, "c")
}
