% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blank.R
\name{blank_values}
\alias{blank_values}
\alias{is_blank}
\alias{select_blank_cols}
\alias{remove_blank_cols}
\alias{is_blank_cols}
\title{Blank values}
\usage{
is_blank(x, na_blank = FALSE, ws = TRUE)

select_blank_cols(x, na_blank = FALSE, ws = TRUE)

remove_blank_cols(x, na_blank = FALSE, ws = TRUE)

is_blank_cols(x, names = TRUE, na_blank = FALSE, ws = TRUE)
}
\arguments{
\item{x}{An object, or \code{data.frame} for \verb{*_cols()} functions}

\item{na_blank}{Logical, if \code{TRUE} treats \code{NA} values as \emph{blank}}

\item{ws}{Logical, when \code{TRUE} treats elements that are entirely \emph{whitespace}
as blanks}

\item{names}{Logical, if \code{TRUE} (default) will return column names as names
of vector}
}
\value{
\itemize{
\item \code{is_blank()} a \code{logical} vector indicating \emph{blank} elements in \code{x}
\item \code{select_blank_cols()} \code{x} with only columns that are all \emph{blank}
\item \code{remove_blank_cols()} \code{x} without columns of only \emph{blank}
\item \code{is_blank_cols()} a logical vector: \code{TRUE} all rows of column are \emph{blank},
otherwise \code{FALSE}
}
}
\description{
Detect \emph{blank} values; select, remove columns that are entirely \emph{blank}
}
\details{
\emph{Blank} values are values that do not contain any text
}
