% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_logl.R
\name{gamma_logl}
\alias{gamma_logl}
\title{A function to calculate the log-likelihood of Gamma model}
\usage{
gamma_logl(param, x)
}
\arguments{
\item{param}{parameters of Gamma model}

\item{x}{input data for Gamma model}
}
\value{
returns the value of negative log-likelihood of the Gamma model
}
\description{
A function to calculate the log-likelihood of Gamma model
}
\examples{
set.seed(42)
data <-  rgamma(30,3,0.01)

# set some parameters
par_hat <- c(2.7626793657057762, 0.0094307059277139432) # estimated parameters
param <- log(par_hat) # input parameters for logl function

# calculate log-likelihood
result <- marp::gamma_logl(param, data)

# print result
cat("-logl = ", result, "\n")

}
