% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\docType{data}
\name{style-helpers}
\alias{style-helpers}
\alias{relative}
\alias{em}
\alias{rem}
\alias{trbl}
\alias{skip_inherit}
\alias{marquee_bullets}
\title{Helpers for defining styles}
\format{
An object of class \code{character} of length 6.
}
\usage{
relative(x)

em(x)

rem(x)

trbl(top = NULL, right = top, bottom = top, left = right)

skip_inherit(x)

marquee_bullets
}
\arguments{
\item{x}{A decimal number. If a vector is provided only the first element
will be used}

\item{top, right, bottom, left}{Values for the sides of the rectangles. Either
numbers or modifiers (relative, em, or rem)}
}
\value{
Objects of the relevant class
}
\description{
marquee provides a small set of helpers for constructing the needed styles.
\code{relative()} specifies a numeric value as relative to the value of the parent
style by a certain factor, e.g. a font size of \code{relative(0.5)} would give a
style a font size half of it's parent. \code{em()} specify a numeric value as
relative to the font size of the current style. If the font size is \code{12}, and
indent is set to \code{em(2)}, then the indent will be equivalent to 24. \code{rem()}
works like \code{em()} but rather than using the font size of the current style it
uses the font size of the root style (which is the body element). \code{trbl()}
helps you construct styles that refers to sides of a rectangle (margin,
padding, and border size). The function names refers to the order of the
arguments (top, right, bottom, left). \code{skip_inherit()} tells the style
inheritance to ignore this value and look for the value one above in the
stack. \code{marquee_bullets} is just a character vector with 6 sensible bullet
glyphs for unordered lists.
}
\examples{
relative(0.35)

em(2)

rem(1.2)

# Argument default means it recycles like CSS if fewer values are specified
trbl(6, em(1.5))

skip_inherit("sans")

marquee_bullets

}
\keyword{datasets}
