% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods_scaleddata.R
\name{calc_relative_lik_matrix}
\alias{calc_relative_lik_matrix}
\title{Calculate matrix of relative likelihoods.}
\usage{
calc_relative_lik_matrix(data, Ulist, algorithm.version = c("Rcpp", "R"))
}
\arguments{
\item{data}{A \code{mash} data object; e.g., created by
\code{\link{mash_set_data}}.}

\item{Ulist}{List containing the prior covariance matrices.}

\item{algorithm.version}{indicates R or Rcpp}
}
\value{
The return value is a list containing the following components:

    \item{lik_matrix}{J x P matrix containing likelihoods p(bhat[j]
      + Ulist[p], V), but normalized so that the largest entry in
      each row is 1.}

    \item{lfactors}{Vector which will recover the original
      likelihoods; for example, \code{lfactors[i] +
      log(lik_matrix[i,])} yields the log-likelihoods corresponding
      to row i of the Bhat data matrix.}
}
\description{
Computes matrix of relative likelihoods for each of J
  rows of Bhat for each of P prior covariances.

  This is an internal (non-exported) function. This help page
  provides additional documentation mainly intended for developers
  and expert users.
}
\keyword{internal}
