% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods_scaleddata.R
\name{calc_lik_matrix}
\alias{calc_lik_matrix}
\title{Compute matrix of conditional likelihoods.}
\usage{
calc_lik_matrix(
  data,
  Ulist,
  log = FALSE,
  mc.cores = 1,
  algorithm.version = c("Rcpp", "R")
)
}
\arguments{
\item{data}{A \code{mash} data object; e.g., created by
\code{\link{mash_set_data}}.}

\item{Ulist}{List containing the prior covariance matrices.}

\item{log}{If \code{TRUE}, the return value is a matrix of log-
likelihoods.}

\item{mc.cores}{The argument supplied to
\code{openmp} specifying the number of cores
to use. Note that this is only has an effect for the Rcpp version.}

\item{algorithm.version}{Indicate R or Rcpp version}
}
\value{
J x P matrix of multivariate normal likelihoods, p(bhat |
    Ulist[p], V).
}
\description{
computes matrix of condition likelihoods for each of J
  rows of Bhat for each of P prior covariances.

  This is an internal (non-exported) function. This help page
  provides additional documentation mainly intended for developers
  and expert users.
}
\keyword{internal}
