% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data2cov.R
\name{cov_ed}
\alias{cov_ed}
\title{Perform "extreme deconvolution" (Bovy et al) on a subset of
the data}
\usage{
cov_ed(data, Ulist_init, subset = NULL, algorithm = c("bovy", "teem"), ...)
}
\arguments{
\item{data}{a mash data object}

\item{Ulist_init}{a named list of covariance matrices to use to
initialize ED; default is to use matrices from PCs}

\item{subset}{a subset of data to be used when ED is run (set to
NULL for all the data)}

\item{algorithm}{algorithm to run ED}

\item{...}{other arguments to be passed to ED algorith, see
\code{\link{extreme_deconvolution}} for algorithm 'bovy', or
\code{\link{teem_wrapper}} for algorithm 'teem'}
}
\description{
Perform "extreme deconvolution" (Bovy et al) on a subset of
the data
}
\details{
Runs the extreme deconvolution algorithm from Bovy et al
(Annals of Applied Statistics) to estimate data-driven covariance
matrices. It can be initialized with, for example running \code{cov_pca} with,
say, 5 PCs.
}
\examples{
data = mash_set_data(Bhat = cbind(c(1,2),c(3,4)), Shat = cbind(c(1,1),c(1,1)))
U_pca = cov_pca(data,2)
U_x = apply(data$Bhat, 2, function(x) x - mean(x))
U_xx = t(U_x) \%*\% U_x / nrow(U_x)
cov_ed(data,c(U_pca, list(xx = U_xx)))

}
