% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focal.R
\name{focalCompare}
\alias{focalCompare}
\title{Generate layers based on different focal windows}
\usage{
focalCompare(layer, windowSizes, fun, mc.cores = 1)
}
\arguments{
\item{layer}{A single raster layer to be summarized.}

\item{windowSizes}{A vector of the number of cell in each direction to buffer for the focal summary. E.g., a value of 1 indicates the 8 cells immediately surrounding the focal cell, i.e., which are 1 cell away.}

\item{fun}{The function fun should take multiple numbers, and return a single number. For example mean, modal, min or max. It should also accept a na.rm argument (or ignore it, e.g. as one of the 'dots' arguments. For example, length will fail, but function(x, ...){na.omit(length(x))} works. (Specifications from `raster::focal`)}

\item{mc.cores}{Number of cores for (optional) parallelization}
}
\value{
Raster object
}
\description{
Aids in exploring how different focal regions may affect masks.
}
\details{
See Examples.
}
\note{
This may be particularly useful if for mobile species when their movement patterns cover a much larger extent than the single cell in which they were observed.
}
\examples{
r <- raster::raster(ncols=36, nrows=18, xmn=0)
r[] <- runif(raster::ncell(r)) 
r15 <- focalCompare(r, windowSizes = c(1:5),mc.cores=1,fun=mean) 
}
\author{
Cory Merow <cory.merow@gmail.com>,
}
