% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchMulti-internal.R
\name{smahal}
\alias{smahal}
\title{Robust Mahalanobis Distance}
\usage{
smahal(z, X)
}
\arguments{
\item{z}{vector of treatment indicators (1 for treated, 0 for controls).}

\item{X}{matrix of numeric variables to be used for computing the
Mahalanobis distance.  Row count must match length of \code{z}.}
}
\value{
a matrix of robust Mahalanobis distances, with a row for each
treated unit and a column for each control.
}
\description{
Computes robust Mahalanobis distance between treated and control units.
}
\details{
For an explanation of the robust Mahalanobis distance, see section 8.3 of
the first reference.  This function was written by Paul Rosenbaum and
distributed in the supplemental material to the second reference.
}
\references{
Rosenbaum, Paul R. (2010). \emph{Design of Observational
Studies}.  Springer-Verlag.

Rosenbaum, Paul R. (2012) "Optimal Matching of an Optimally Chosen Subset in
Observational Studies."  Journal of Computational and Graphical Statistics,
21.1, 57-71.
}
\author{
Paul R. Rosenbaum.
}
\keyword{internal}
